/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.ZoomLimiter;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelPlacement;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.layers.tile.vector.labeling.LabelTileLoaderHook;
import org.oscim.layers.tile.vector.labeling.TextRenderer;
import org.oscim.map.Map;
import org.oscim.utils.async.SimpleWorker;

public class LabelLayer
extends Layer
implements Map.UpdateListener,
TileManager.Listener,
ZoomLimiter.IZoomLimiter {
    static final String LABEL_DATA = LabelLayer.class.getName();
    private static final long MAX_RELABEL_DELAY = 100L;
    private static final int ZOOM_LIMIT = 20;
    private final LabelPlacement mLabelPlacer;
    private final Worker mWorker;
    private final ZoomLimiter mZoomLimiter;

    public LabelLayer(Map map, VectorTileLayer l) {
        this(map, l, new LabelTileLoaderHook());
    }

    public LabelLayer(Map map, VectorTileLayer l, VectorTileLayer.TileLoaderThemeHook h) {
        this(map, l, h, 20);
    }

    public LabelLayer(Map map, VectorTileLayer l, VectorTileLayer.TileLoaderThemeHook h, int zoomLimit) {
        super(map);
        this.mZoomLimiter = new ZoomLimiter(l.getManager(), map.viewport().getMinZoomLevel(), map.viewport().getMaxZoomLevel(), zoomLimit);
        this.mLabelPlacer = new LabelPlacement(map, l.tileRenderer(), this.mZoomLimiter);
        this.mWorker = new Worker(map);
        this.mRenderer = new TextRenderer(this.mWorker);
        l.getManager().events.bind(this);
        l.addHook(h);
    }

    @Override
    public void addZoomLimit() {
        this.mZoomLimiter.addZoomLimit();
    }

    @Override
    public void removeZoomLimit() {
        this.mZoomLimiter.removeZoomLimit();
    }

    public void clearLabels() {
        this.mWorker.cancel(true);
    }

    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        this.mWorker.submit(100L);
    }

    @Override
    public void onDetach() {
        this.mWorker.cancel(true);
        super.onDetach();
    }

    @Override
    public void onMapEvent(Event event, MapPosition mapPosition) {
        if (event == Map.CLEAR_EVENT) {
            this.mWorker.cancel(true);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (event == Map.POSITION_EVENT) {
            this.mWorker.submit(100L);
        }
    }

    @Override
    public void onTileManagerEvent(Event e, MapTile tile) {
        if (e == TileManager.TILE_LOADED) {
            if (tile.isVisible && this.isEnabled()) {
                this.mWorker.submit(25L);
            }
        } else if (e == TileManager.TILE_REMOVED) {
            // empty if block
        }
    }

    class Worker
    extends SimpleWorker<LabelTask> {
        public Worker(Map map) {
            super(map, 50L, new LabelTask(), new LabelTask());
        }

        @Override
        public boolean doWork(LabelTask t) {
            if (LabelLayer.this.mLabelPlacer.updateLabels(t)) {
                this.mMap.render();
                return true;
            }
            return false;
        }

        @Override
        public void cleanup(LabelTask t) {
        }

        @Override
        public void finish() {
            LabelLayer.this.mLabelPlacer.cleanup();
        }

        @Override
        public synchronized boolean isRunning() {
            return this.mRunning;
        }
    }
}

