/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.utils.FastMath;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexData
extends Inlist.List<Chunk> {
    static final Logger log = LoggerFactory.getLogger(VertexData.class);
    public static final int SIZE = 360;
    private static final int MAX_POOL = 500;
    private static final Pool pool = new Pool();
    private Chunk cur;
    private int used = 360;
    private short[] vertices;

    public int countSize() {
        if (this.cur == null) {
            return 0;
        }
        this.cur.used = this.used;
        int size = 0;
        Chunk it = (Chunk)this.head();
        while (it != null) {
            size += it.used;
            it = (Chunk)it.next;
        }
        return size;
    }

    @Override
    public Chunk clear() {
        if (this.cur == null) {
            return null;
        }
        this.cur.used = this.used;
        this.used = 360;
        this.cur = null;
        this.vertices = null;
        return (Chunk)super.clear();
    }

    public void dispose() {
        pool.releaseAll((Chunk)super.clear());
        this.used = 360;
        this.cur = null;
        this.vertices = null;
    }

    public int compile(ShortBuffer sbuf) {
        if (this.cur == null) {
            return 0;
        }
        this.cur.used = this.used;
        int size = 0;
        Chunk it = (Chunk)this.head();
        while (it != null) {
            size += it.used;
            sbuf.put(it.vertices, 0, it.used);
            it = (Chunk)it.next;
        }
        this.dispose();
        return size;
    }

    private void getNext() {
        if (this.cur == null) {
            this.cur = (Chunk)pool.get();
            this.push(this.cur);
        } else {
            if (this.cur.next != null) {
                throw new IllegalStateException("seeeked...");
            }
            this.cur.used = 360;
            this.cur.next = pool.get();
            this.cur = (Chunk)this.cur.next;
        }
        this.vertices = this.cur.vertices;
        this.used = 0;
    }

    public void add(float a) {
        this.add(VertexData.toShort(a));
    }

    public void add(short a) {
        if (this.used == 360) {
            this.getNext();
        }
        this.vertices[this.used++] = a;
    }

    public void add(float a, float b) {
        this.add(VertexData.toShort(a), VertexData.toShort(b));
    }

    public void add(short a, short b) {
        if (this.used == 360) {
            this.getNext();
        }
        this.vertices[this.used + 0] = a;
        this.vertices[this.used + 1] = b;
        this.used += 2;
    }

    public void add(float a, float b, float c) {
        this.add(VertexData.toShort(a), VertexData.toShort(b), VertexData.toShort(c));
    }

    public void add(short a, short b, short c) {
        if (this.used == 360) {
            this.getNext();
        }
        this.vertices[this.used + 0] = a;
        this.vertices[this.used + 1] = b;
        this.vertices[this.used + 2] = c;
        this.used += 3;
    }

    public void add(float a, float b, float c, float d) {
        this.add(VertexData.toShort(a), VertexData.toShort(b), VertexData.toShort(c), VertexData.toShort(d));
    }

    public void add(short a, short b, short c, short d) {
        if (this.used == 360) {
            this.getNext();
        }
        this.vertices[this.used + 0] = a;
        this.vertices[this.used + 1] = b;
        this.vertices[this.used + 2] = c;
        this.vertices[this.used + 3] = d;
        this.used += 4;
    }

    public void add(float a, float b, float c, float d, float e, float f) {
        this.add(VertexData.toShort(a), VertexData.toShort(b), VertexData.toShort(c), VertexData.toShort(d), VertexData.toShort(e), VertexData.toShort(f));
    }

    public void add(short a, short b, short c, short d, short e, short f) {
        if (this.used == 360) {
            this.getNext();
        }
        this.vertices[this.used + 0] = a;
        this.vertices[this.used + 1] = b;
        this.vertices[this.used + 2] = c;
        this.vertices[this.used + 3] = d;
        this.vertices[this.used + 4] = e;
        this.vertices[this.used + 5] = f;
        this.used += 6;
    }

    public boolean empty() {
        return this.cur == null;
    }

    public Chunk obtainChunk() {
        if (this.used == 360) {
            this.getNext();
        }
        this.cur.used = this.used;
        return this.cur;
    }

    public void releaseChunk() {
        this.used = this.cur.used;
    }

    public void releaseChunk(int size) {
        this.cur.used = size;
        this.used = size;
    }

    public void seek(int offset) {
        this.used += offset;
        this.cur.used = this.used;
        if (this.used > 360 || this.used < 0) {
            throw new IllegalStateException("seeked too far: " + offset + "/" + this.used);
        }
    }

    static final short toShort(float v) {
        return (short)FastMath.clamp(v, -32768.0f, 32767.0f);
    }

    public static class Chunk
    extends Inlist<Chunk> {
        public final short[] vertices = new short[360];
        public int used;
    }

    private static class Pool
    extends SyncPool<Chunk> {
        public Pool() {
            super(500);
        }

        @Override
        protected Chunk createItem() {
            return new Chunk();
        }

        @Override
        protected boolean clearItem(Chunk it) {
            it.used = 0;
            return true;
        }
    }
}

