/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.light;

import java.nio.FloatBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.ExtrusionRenderer;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.light.ShadowFrameBuffer;
import org.oscim.utils.math.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowRenderer
extends LayerRenderer {
    private static final Logger log = LoggerFactory.getLogger(ShadowRenderer.class);
    public static boolean DEBUG = false;
    private ExtrusionRenderer mRenderer;
    private float SHADOWMAP_RESOLUTION = 2048.0f;
    private int mGroundQuad;
    private ShadowFrameBuffer mFrameBuffer;
    private float[] mOrthoMat = new float[16];
    private float[] mViewProjTmp = new float[16];
    private GLMatrix mLightMat = new GLMatrix();
    private GLMatrix mRotTmp = new GLMatrix();
    static float[] texUnitConverterF = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
    static GLMatrix texUnitConverter = new GLMatrix();
    private Shader mExtrusionShader;
    private GroundShader mGroundShader;
    private ExtrusionRenderer.Shader mLightShader;

    public ShadowRenderer(ExtrusionRenderer renderer) {
        this.setRenderer(renderer);
    }

    public void setRenderer(ExtrusionRenderer renderer) {
        this.mRenderer = renderer;
    }

    private static int bindPlane(float width, float height) {
        int[] vboIds = GLUtils.glGenBuffers(1);
        FloatBuffer floatBuffer = MapRenderer.getFloatBuffer(8);
        float[] quad = new float[]{-width, height, width, height, -width, -height, width, -height};
        floatBuffer.put(quad);
        floatBuffer.flip();
        int vertexBuffer = vboIds[0];
        GLState.bindVertexBuffer(vertexBuffer);
        GLAdapter.gl.bufferData(34962, quad.length * 4, floatBuffer, 35044);
        GLState.bindVertexBuffer(0);
        return vertexBuffer;
    }

    @Override
    public boolean setup() {
        this.mGroundQuad = !DEBUG ? ShadowRenderer.bindPlane(32767.0f, 32767.0f) : ShadowRenderer.bindPlane(this.SHADOWMAP_RESOLUTION * 1.1f, this.SHADOWMAP_RESOLUTION * 1.1f);
        this.mGroundShader = new GroundShader("extrusion_shadow_ground");
        this.mLightShader = new ExtrusionRenderer.Shader("extrusion_shadow_light");
        this.mExtrusionShader = this.mRenderer.isMesh() ? new Shader("extrusion_layer_mesh") : new Shader("extrusion_layer_ext");
        this.mFrameBuffer = new ShadowFrameBuffer((int)this.SHADOWMAP_RESOLUTION, (int)this.SHADOWMAP_RESOLUTION);
        return super.setup();
    }

    @Override
    public void update(GLViewport viewport) {
        this.mRenderer.update(viewport);
        this.setReady(this.mRenderer.isReady());
    }

    @Override
    public void render(GLViewport viewport) {
        viewport.viewproj.get(this.mViewProjTmp);
        float projWidth = this.SHADOWMAP_RESOLUTION;
        float projHeight = this.SHADOWMAP_RESOLUTION;
        if (DEBUG) {
            projWidth = (float)((double)projWidth * 0.75);
            projHeight = (float)((double)projHeight * 0.75);
        }
        GLMatrix.orthoM(this.mOrthoMat, 0, -projWidth, projWidth, projHeight, -projHeight, -this.SHADOWMAP_RESOLUTION, this.SHADOWMAP_RESOLUTION);
        viewport.viewproj.set(this.mOrthoMat);
        float[] lightPos = this.mRenderer.getSun().getPosition();
        float rot = (float)Math.acos((double)lightPos[2] / 1.0) * 57.295776f;
        this.mRotTmp.setRotation(rot, 1.0f, 0.0f, 0.0f);
        viewport.viewproj.multiplyRhs(this.mRotTmp);
        rot = MathUtils.atan2(lightPos[0], lightPos[1]) * 57.295776f;
        this.mRotTmp.setRotation(rot, 0.0f, 0.0f, 1.0f);
        viewport.viewproj.multiplyRhs(this.mRotTmp);
        this.mFrameBuffer.bindFrameBuffer();
        GLState.blend(false);
        GLAdapter.gl.depthMask(true);
        GLState.test(true, false);
        GLAdapter.gl.clear(0x4000 | 0x100);
        this.mRenderer.setShader(this.mLightShader);
        this.mRenderer.useLight(false);
        this.mRenderer.render(viewport);
        this.mFrameBuffer.unbindFrameBuffer();
        this.mLightMat.copy(viewport.viewproj);
        this.mLightMat.multiplyLhs(texUnitConverter);
        viewport.viewproj.set(this.mViewProjTmp);
        int lightColor = this.mRenderer.getSun().getColor();
        GLState.test(false, false);
        GLAdapter.gl.clear(256);
        GLAdapter.gl.activeTexture(33986);
        GLState.bindTex2D(this.mFrameBuffer.getShadowMap());
        this.mGroundShader.useProgram();
        viewport.viewproj.setAsUniform(this.mGroundShader.uMVP);
        GLAdapter.gl.uniform1i(this.mGroundShader.uShadowMap, 2);
        GLUtils.setColor(this.mGroundShader.uLightColor, lightColor);
        GLAdapter.gl.uniform1f(this.mGroundShader.uShadowRes, this.SHADOWMAP_RESOLUTION);
        this.mLightMat.setAsUniform(this.mGroundShader.uLightMvp);
        GLState.bindVertexBuffer(this.mGroundQuad);
        GLState.enableVertexArrays(this.mGroundShader.aPos, -1);
        GLAdapter.gl.vertexAttribPointer(this.mGroundShader.aPos, 2, 5126, false, 0, 0);
        MapRenderer.bindQuadIndicesVBO();
        GLState.blend(true);
        GLAdapter.gl.blendFunc(0, 768);
        GLAdapter.gl.drawElements(4, 6, 5123, 0);
        GLState.blend(false);
        GLAdapter.gl.blendFunc(1, 771);
        this.mExtrusionShader.useProgram();
        GLAdapter.gl.uniform1i(this.mExtrusionShader.uShadowMap, 2);
        GLUtils.setColor(this.mExtrusionShader.uLightColor, lightColor);
        GLAdapter.gl.uniform1f(this.mExtrusionShader.uShadowRes, this.SHADOWMAP_RESOLUTION);
        this.mExtrusionShader.lightMat = this.mLightMat;
        this.mRenderer.setShader(this.mExtrusionShader);
        this.mRenderer.useLight(true);
        this.mRenderer.render(viewport);
        GLAdapter.gl.activeTexture(33984);
    }

    static {
        texUnitConverter.set(texUnitConverterF);
    }

    public static class GroundShader
    extends GLShader {
        int aPos;
        int uLightColor;
        int uLightMvp;
        int uMVP;
        int uShadowMap;
        int uShadowRes;

        public GroundShader(String shader) {
            if (!this.createDirective(shader, "#define SHADOW 1\n")) {
                return;
            }
            this.aPos = this.getAttrib("a_pos");
            this.uLightColor = this.getUniform("u_lightColor");
            this.uLightMvp = this.getUniform("u_light_mvp");
            this.uMVP = this.getUniform("u_mvp");
            this.uShadowMap = this.getUniform("u_shadowMap");
            this.uShadowRes = this.getUniform("u_shadowRes");
        }
    }

    public static class Shader
    extends ExtrusionRenderer.Shader {
        static final GLMatrix lightMvp = new GLMatrix();
        GLMatrix lightMat = null;
        int uLightColor = this.getUniform("u_lightColor");
        int uLightMvp = this.getUniform("u_light_mvp");
        int uShadowMap = this.getUniform("u_shadowMap");
        int uShadowRes = this.getUniform("u_shadowRes");

        public Shader(String shader) {
            super(shader, "#define SHADOW 1\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLightMVP(GLMatrix model) {
            if (this.lightMat == null) {
                return;
            }
            GLMatrix gLMatrix = lightMvp;
            synchronized (gLMatrix) {
                lightMvp.copy(model);
                lightMvp.multiplyLhs(this.lightMat);
                lightMvp.setAsUniform(this.uLightMvp);
            }
        }
    }
}

