/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.theme.XmlThemeResourceProvider;
import org.oscim.utils.Utils;

public class ZipRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private boolean mMapsforgeTheme;
    private XmlRenderThemeMenuCallback mMenuCallback;
    private final String mRelativePathPrefix;
    private XmlThemeResourceProvider mResourceProvider;
    protected final String mXmlTheme;

    public ZipRenderTheme(String xmlTheme, XmlThemeResourceProvider resourceProvider) throws IRenderTheme.ThemeException {
        this(xmlTheme, resourceProvider, null);
    }

    public ZipRenderTheme(String xmlTheme, XmlThemeResourceProvider resourceProvider, XmlRenderThemeMenuCallback menuCallback) throws IRenderTheme.ThemeException {
        this.mXmlTheme = xmlTheme;
        this.mResourceProvider = resourceProvider;
        this.mMenuCallback = menuCallback;
        this.mRelativePathPrefix = xmlTheme.substring(0, xmlTheme.lastIndexOf("/") + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZipRenderTheme)) {
            return false;
        }
        ZipRenderTheme other = (ZipRenderTheme)obj;
        if (this.getRenderThemeAsStream() != other.getRenderThemeAsStream()) {
            return false;
        }
        return Utils.equals(this.mRelativePathPrefix, other.mRelativePathPrefix);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.mRelativePathPrefix;
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        try {
            return this.mResourceProvider.createInputStream(this.mRelativePathPrefix, this.mXmlTheme.substring(this.mXmlTheme.lastIndexOf("/") + 1));
        }
        catch (IOException e) {
            throw new IRenderTheme.ThemeException(e.toString(), e);
        }
    }

    @Override
    public XmlThemeResourceProvider getResourceProvider() {
        return this.mResourceProvider;
    }

    @Override
    public boolean isMapsforgeTheme() {
        return this.mMapsforgeTheme;
    }

    @Override
    public void setMapsforgeTheme(boolean mapsforgeTheme) {
        this.mMapsforgeTheme = mapsforgeTheme;
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback menuCallback) {
        this.mMenuCallback = menuCallback;
    }

    @Override
    public void setResourceProvider(XmlThemeResourceProvider resourceProvider) {
        this.mResourceProvider = resourceProvider;
    }
}

