/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.rule;

import java.util.List;
import org.oscim.core.Tag;
import org.oscim.theme.rule.RuleBuilder;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.Utils;

public class Rule {
    public static final RenderStyle[] EMPTY_STYLE = new RenderStyle[0];
    public static final Rule[] EMPTY_RULES = new Rule[0];
    public final Rule[] subRules;
    public final RenderStyle[] styles;
    public String cat;
    public final int zoom;
    public final int element;
    public final boolean selectFirstMatch;
    public final boolean selectWhenMatched;

    Rule(int element, int zoom, int selector, Rule[] subRules, RenderStyle[] styles) {
        this.element = element;
        this.zoom = zoom;
        this.subRules = subRules == null ? EMPTY_RULES : subRules;
        this.styles = styles == null ? EMPTY_STYLE : styles;
        this.selectFirstMatch = (selector & 1) != 0;
        this.selectWhenMatched = (selector & 2) != 0;
    }

    public boolean matchesTags(Tag[] tags) {
        return true;
    }

    public boolean matchElement(int type, Tag[] tags, int zoomLevel, List<RenderStyle> result) {
        if ((this.element & type) == 0 || (this.zoom & zoomLevel) == 0 || !this.matchesTags(tags)) {
            return false;
        }
        boolean matched = false;
        if (this.subRules != EMPTY_RULES) {
            if (this.selectFirstMatch) {
                for (Rule rule : this.subRules) {
                    if (matched ^ rule.selectWhenMatched || !rule.matchElement(type, tags, zoomLevel, result)) continue;
                    matched = true;
                }
            } else {
                for (Rule rule : this.subRules) {
                    if (rule.selectWhenMatched && !matched || !rule.matchElement(type, tags, zoomLevel, result)) continue;
                    matched = true;
                }
            }
        }
        if (this.styles == EMPTY_STYLE) {
            return matched;
        }
        for (RenderStyle renderStyle : this.styles) {
            result.add(renderStyle);
        }
        return true;
    }

    public void dispose() {
        for (RenderStyle ri : this.styles) {
            ri.dispose();
        }
        for (Rule subRule : this.subRules) {
            subRule.dispose();
        }
    }

    public void scaleTextSize(float scaleFactor) {
        for (RenderStyle ri : this.styles) {
            ri.scaleTextSize(scaleFactor);
        }
        for (Rule subRule : this.subRules) {
            subRule.scaleTextSize(scaleFactor);
        }
    }

    public Rule setCat(String cat) {
        this.cat = cat;
        return this;
    }

    public void updateStyles() {
        for (RenderStyle ri : this.styles) {
            ri.update();
        }
        for (Rule subRule : this.subRules) {
            subRule.updateStyles();
        }
    }

    public void apply(RuleVisitor v) {
        v.apply(this);
    }

    public static RuleBuilder builder() {
        return new RuleBuilder();
    }

    public final class Selector {
        public static final int ANY = 0;
        public static final int FIRST = 1;
        public static final int WHEN_MATCHED = 2;
    }

    public static class RuleVisitor {
        public void apply(Rule r) {
            for (Rule subRule : r.subRules) {
                this.apply(subRule);
            }
        }
    }

    static class NegativeRule
    extends Rule {
        public final String[] keys;
        public final String[] values;
        public final boolean exclusive;

        NegativeRule(RuleBuilder.RuleType type, int element, int zoom, int selector, String[] keys, String[] values, Rule[] subRules, RenderStyle[] styles) {
            super(element, zoom, selector, subRules, styles);
            this.keys = keys;
            this.values = values;
            this.exclusive = type == RuleBuilder.RuleType.EXCLUDE;
        }

        @Override
        public boolean matchesTags(Tag[] tags) {
            if (!this.containsKeys(tags)) {
                return true;
            }
            for (Tag tag : tags) {
                for (String value : this.values) {
                    if (!Utils.equals(value, tag.value)) continue;
                    return !this.exclusive;
                }
            }
            return this.exclusive;
        }

        private boolean containsKeys(Tag[] tags) {
            for (Tag tag : tags) {
                for (String key : this.keys) {
                    if (!Utils.equals(key, tag.key)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class PositiveRuleMultiKV
    extends Rule {
        private final String[] mKeys;
        private final String[] mValues;

        PositiveRuleMultiKV(int element, int zoom, int selector, String[] keys, String[] values, Rule[] subRules, RenderStyle[] styles) {
            super(element, zoom, selector, subRules, styles);
            this.mKeys = keys.length == 0 ? null : keys;
            this.mValues = values.length == 0 ? null : values;
        }

        @Override
        public boolean matchesTags(Tag[] tags) {
            if (this.mKeys == null) {
                for (Tag tag : tags) {
                    for (String value : this.mValues) {
                        if (!Utils.equals(value, tag.value)) continue;
                        return true;
                    }
                }
                return false;
            }
            for (Tag tag : tags) {
                for (String key : this.mKeys) {
                    if (!Utils.equals(key, tag.key)) continue;
                    if (this.mValues == null) {
                        return true;
                    }
                    for (String value : this.mValues) {
                        if (!Utils.equals(value, tag.value)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static class PositiveRuleKV
    extends Rule {
        private final String mKey;
        private final String mValue;

        PositiveRuleKV(int element, int zoom, int selector, String key, String value, Rule[] subRules, RenderStyle[] styles) {
            super(element, zoom, selector, subRules, styles);
            this.mKey = key;
            this.mValue = value;
        }

        @Override
        public boolean matchesTags(Tag[] tags) {
            for (Tag tag : tags) {
                if (!Utils.equals(this.mKey, tag.key)) continue;
                return Utils.equals(this.mValue, tag.value);
            }
            return false;
        }
    }

    static class PositiveRuleV
    extends Rule {
        private final String mValue;

        PositiveRuleV(int element, int zoom, int selector, String value, Rule[] subRules, RenderStyle[] styles) {
            super(element, zoom, selector, subRules, styles);
            this.mValue = value;
        }

        @Override
        public boolean matchesTags(Tag[] tags) {
            for (Tag tag : tags) {
                if (!Utils.equals(this.mValue, tag.value)) continue;
                return true;
            }
            return false;
        }
    }

    static class PositiveRuleK
    extends Rule {
        private final String mKey;

        PositiveRuleK(int element, int zoom, int selector, String key, Rule[] subRules, RenderStyle[] styles) {
            super(element, zoom, selector, subRules, styles);
            this.mKey = key;
        }

        @Override
        public boolean matchesTags(Tag[] tags) {
            for (Tag tag : tags) {
                if (!Utils.equals(this.mKey, tag.key)) continue;
                return true;
            }
            return false;
        }
    }

    public static class UpdateVisitor
    extends RuleVisitor {
        @Override
        public void apply(Rule r) {
            for (RenderStyle ri : r.styles) {
                ri.update();
            }
            super.apply(r);
        }
    }

    public static class TextSizeVisitor
    extends RuleVisitor {
        float scaleFactor = 1.0f;

        public void setScaleFactor(float scaleFactor) {
            this.scaleFactor = scaleFactor;
        }

        @Override
        public void apply(Rule r) {
            for (RenderStyle ri : r.styles) {
                ri.scaleTextSize(this.scaleFactor);
            }
            super.apply(r);
        }
    }

    public final class Closed {
        public static final int NO = 1;
        public static final int YES = 2;
        public static final int ANY = 3;
    }

    public final class Element {
        public static final int NODE = 1;
        public static final int LINE = 2;
        public static final int POLY = 4;
        public static final int WAY = 6;
        public static final int ANY = 7;
    }
}

