/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.styles.RenderStyle;

public final class LineStyle
extends RenderStyle<LineStyle> {
    public static final float REPEAT_START_DEFAULT = 30.0f;
    public static final float REPEAT_GAP_DEFAULT = 200.0f;
    private final int level;
    public final String style;
    public final float width;
    public final int color;
    public final Paint.Cap cap;
    public final boolean outline;
    public final boolean fixed;
    public final double strokeIncrease;
    public final int fadeScale;
    public final float blur;
    public final int stipple;
    public final int stippleColor;
    public final float stippleWidth;
    public final TextureItem texture;
    public final float heightOffset;
    public final boolean randomOffset;
    public final int symbolWidth;
    public final int symbolHeight;
    public final int symbolPercent;
    public final float[] dashArray;
    public final float repeatStart;
    public final float repeatGap;
    public final boolean transparent;

    public LineStyle(int color, float width) {
        this(0, "", color, width, Paint.Cap.BUTT, true, 1.0, 0, 0, 0.0f, -1, 0.0f, false, null, true, null, 30.0f * CanvasAdapter.getScale(), 200.0f * CanvasAdapter.getScale(), false);
    }

    public LineStyle(int level, int color, float width) {
        this(level, "", color, width, Paint.Cap.BUTT, true, 1.0, 0, 0, 0.0f, -1, 0.0f, false, null, true, null, 30.0f * CanvasAdapter.getScale(), 200.0f * CanvasAdapter.getScale(), false);
    }

    public LineStyle(int color, float width, Paint.Cap cap) {
        this(0, "", color, width, cap, true, 1.0, 0, 0, 0.0f, -1, 0.0f, false, null, true, null, 30.0f * CanvasAdapter.getScale(), 200.0f * CanvasAdapter.getScale(), false);
    }

    public LineStyle(int level, String style, int color, float width, Paint.Cap cap, boolean fixed, double strokeIncrease, int stipple, int stippleColor, float stippleWidth, int fadeScale, float blur, boolean isOutline, TextureItem texture, boolean randomOffset, float[] dashArray, float repeatStart, float repeatGap, boolean transparent) {
        this.level = level;
        this.style = style;
        this.outline = isOutline;
        this.cap = cap;
        this.color = color;
        this.width = width;
        this.fixed = fixed;
        this.strokeIncrease = strokeIncrease;
        this.stipple = stipple;
        this.stippleColor = stippleColor;
        this.stippleWidth = stippleWidth;
        this.texture = texture;
        this.blur = blur;
        this.fadeScale = fadeScale;
        this.heightOffset = 0.0f;
        this.randomOffset = randomOffset;
        this.symbolWidth = 0;
        this.symbolHeight = 0;
        this.symbolPercent = 100;
        this.dashArray = dashArray;
        this.repeatStart = repeatStart;
        this.repeatGap = repeatGap;
        this.transparent = transparent;
    }

    private LineStyle(LineBuilder<?> b) {
        this.cat = b.cat;
        this.level = b.level;
        this.style = b.style;
        this.width = b.strokeWidth;
        this.color = b.themeCallback != null ? b.themeCallback.getColor(this, b.fillColor) : b.fillColor;
        this.cap = b.cap;
        this.outline = b.outline;
        this.fixed = b.fixed;
        this.strokeIncrease = b.strokeIncrease;
        this.fadeScale = b.fadeScale;
        this.blur = b.blur;
        this.stipple = b.stipple;
        this.stippleColor = b.themeCallback != null ? b.themeCallback.getColor(this, b.stippleColor) : b.stippleColor;
        this.stippleWidth = b.stippleWidth;
        this.texture = b.texture;
        this.heightOffset = b.heightOffset;
        this.randomOffset = b.randomOffset;
        this.symbolWidth = b.symbolWidth;
        this.symbolHeight = b.symbolHeight;
        this.symbolPercent = b.symbolPercent;
        this.dashArray = b.dashArray;
        this.repeatStart = b.repeatStart;
        this.repeatGap = b.repeatGap;
        this.transparent = b.transparent;
    }

    @Override
    public LineStyle current() {
        return (LineStyle)this.mCurrent;
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderWay(this, this.level);
    }

    public static LineBuilder<?> builder() {
        return new LineBuilder();
    }

    public static class LineBuilder<T extends LineBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public Paint.Cap cap;
        public boolean outline;
        public boolean fixed;
        public double strokeIncrease;
        public int fadeScale;
        public float blur;
        public int stipple;
        public int stippleColor;
        public float stippleWidth;
        public TextureItem texture;
        public float heightOffset;
        public boolean randomOffset;
        public int symbolWidth;
        public int symbolHeight;
        public int symbolPercent;
        public float[] dashArray;
        public float repeatStart;
        public float repeatGap;
        public boolean transparent;

        public T set(LineStyle line) {
            if (line == null) {
                return this.reset();
            }
            this.cat = line.cat;
            this.level = line.level;
            this.style = line.style;
            this.strokeWidth = line.width;
            this.fillColor = this.themeCallback != null ? this.themeCallback.getColor(line, line.color) : line.color;
            this.cap = line.cap;
            this.outline = line.outline;
            this.fixed = line.fixed;
            this.strokeIncrease = line.strokeIncrease;
            this.fadeScale = line.fadeScale;
            this.blur = line.blur;
            this.stipple = line.stipple;
            this.stippleColor = this.themeCallback != null ? this.themeCallback.getColor(line, line.stippleColor) : line.stippleColor;
            this.stippleWidth = line.stippleWidth;
            this.texture = line.texture;
            this.heightOffset = line.heightOffset;
            this.randomOffset = line.randomOffset;
            this.symbolWidth = line.symbolWidth;
            this.symbolHeight = line.symbolHeight;
            this.symbolPercent = line.symbolPercent;
            this.dashArray = line.dashArray;
            this.repeatStart = line.repeatStart;
            this.repeatGap = line.repeatGap;
            this.transparent = line.transparent;
            return (T)((LineBuilder)this.self());
        }

        public T blur(float blur) {
            this.blur = blur;
            return (T)((LineBuilder)this.self());
        }

        public T fadeScale(int zoom) {
            this.fadeScale = zoom;
            return (T)((LineBuilder)this.self());
        }

        public T stipple(int width) {
            this.stipple = width;
            return (T)((LineBuilder)this.self());
        }

        public T stippleColor(int color) {
            this.stippleColor = color;
            return (T)((LineBuilder)this.self());
        }

        public T stippleColor(String color) {
            this.stippleColor = Color.parseColor(color);
            return (T)((LineBuilder)this.self());
        }

        public T stippleWidth(float width) {
            this.stippleWidth = width;
            return (T)((LineBuilder)this.self());
        }

        public T isOutline(boolean outline) {
            this.outline = outline;
            return (T)((LineBuilder)this.self());
        }

        public T cap(Paint.Cap cap) {
            this.cap = cap;
            return (T)((LineBuilder)this.self());
        }

        public T fixed(boolean b) {
            this.fixed = b;
            return (T)((LineBuilder)this.self());
        }

        public T strokeIncrease(double strokeIncrease) {
            this.strokeIncrease = strokeIncrease;
            return (T)((LineBuilder)this.self());
        }

        public T texture(TextureItem texture) {
            this.texture = texture;
            return (T)((LineBuilder)this.self());
        }

        public T heightOffset(float heightOffset) {
            this.heightOffset = heightOffset;
            return (T)((LineBuilder)this.self());
        }

        public T randomOffset(boolean randomOffset) {
            this.randomOffset = randomOffset;
            return (T)((LineBuilder)this.self());
        }

        public T symbolWidth(int symbolWidth) {
            this.symbolWidth = symbolWidth;
            return (T)((LineBuilder)this.self());
        }

        public T symbolHeight(int symbolHeight) {
            this.symbolHeight = symbolHeight;
            return (T)((LineBuilder)this.self());
        }

        public T symbolPercent(int symbolPercent) {
            this.symbolPercent = symbolPercent;
            return (T)((LineBuilder)this.self());
        }

        public T dashArray(float[] dashArray) {
            this.dashArray = dashArray;
            return (T)((LineBuilder)this.self());
        }

        public T repeatStart(float repeatStart) {
            this.repeatStart = repeatStart;
            return (T)((LineBuilder)this.self());
        }

        public T repeatGap(float repeatGap) {
            this.repeatGap = repeatGap;
            return (T)((LineBuilder)this.self());
        }

        public T transparent(boolean transparent) {
            this.transparent = transparent;
            return (T)((LineBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.style = null;
            this.fillColor = -16777216;
            this.cap = Paint.Cap.ROUND;
            this.outline = false;
            this.strokeWidth = 1.0f;
            this.fixed = false;
            this.strokeIncrease = 1.0;
            this.fadeScale = -1;
            this.blur = 0.0f;
            this.stipple = 0;
            this.stippleWidth = 1.0f;
            this.stippleColor = -16777216;
            this.texture = null;
            this.heightOffset = 0.0f;
            this.randomOffset = true;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            this.dashArray = null;
            this.repeatStart = 30.0f * CanvasAdapter.getScale();
            this.repeatGap = 200.0f * CanvasAdapter.getScale();
            this.transparent = false;
            return (T)((LineBuilder)this.self());
        }

        @Override
        public LineStyle build() {
            return new LineStyle(this);
        }
    }
}

