/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling;

import java.util.HashMap;
import org.oscim.layers.tile.bitmap.BitmapTileLayer;
import org.oscim.tiling.ITileCache;
import org.oscim.tiling.ITileDataSource;

public abstract class TileSource {
    protected float mAlpha = 1.0f;
    protected int mZoomMin = 2;
    protected int mZoomMax = 20;
    protected int mOverZoom = 17;
    protected BitmapTileLayer.FadeStep[] mFadeSteps;
    protected String mName;
    protected int mTileSize = 256;
    protected final Options options = new Options();
    public ITileCache tileCache;

    protected TileSource() {
    }

    protected TileSource(int zoomMin, int zoomMax) {
        this(zoomMin, zoomMax, zoomMax);
    }

    protected TileSource(int zoomMin, int zoomMax, int overZoom) {
        this.mZoomMin = zoomMin;
        this.mZoomMax = zoomMax;
        this.mOverZoom = overZoom;
    }

    public TileSource(Builder<?> builder) {
        this.mAlpha = builder.alpha;
        this.mZoomMin = builder.zoomMin;
        this.mZoomMax = builder.zoomMax;
        this.mOverZoom = builder.overZoom;
        this.mFadeSteps = builder.fadeSteps;
        this.mName = builder.name;
        this.mTileSize = builder.tileSize;
    }

    public abstract ITileDataSource getDataSource();

    public abstract OpenResult open();

    public abstract void close();

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setCache(ITileCache cache) {
        this.tileCache = cache;
    }

    public int getZoomLevelMax() {
        return this.mZoomMax;
    }

    public int getZoomLevelMin() {
        return this.mZoomMin;
    }

    public int getOverZoom() {
        return this.mOverZoom;
    }

    public void setFadeSteps(BitmapTileLayer.FadeStep[] fadeSteps) {
        this.mFadeSteps = fadeSteps;
    }

    public BitmapTileLayer.FadeStep[] getFadeSteps() {
        return this.mFadeSteps;
    }

    public String getName() {
        return this.mName;
    }

    public int getTileSize() {
        return this.mTileSize;
    }

    public TileSource setOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public String getOption(String key) {
        return (String)this.options.get(key);
    }

    public static class Options
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Options)) {
                return false;
            }
            return this.entrySet().equals(((Options)other).entrySet());
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected float alpha = 1.0f;
        protected int zoomMin = 2;
        protected int zoomMax = 20;
        protected int overZoom = 17;
        protected BitmapTileLayer.FadeStep[] fadeSteps;
        protected String name;
        protected int tileSize = 256;

        public T alpha(float alpha) {
            this.alpha = alpha;
            return this.self();
        }

        public T zoomMin(int zoom) {
            this.zoomMin = zoom;
            return this.self();
        }

        public T zoomMax(int zoom) {
            this.zoomMax = zoom;
            return this.self();
        }

        public T overZoom(int zoom) {
            this.overZoom = zoom;
            return this.self();
        }

        public T fadeSteps(BitmapTileLayer.FadeStep[] fadeSteps) {
            this.fadeSteps = fadeSteps;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T tileSize(int tileSize) {
            this.tileSize = tileSize;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        public abstract TileSource build();

        public String getName() {
            return this.name;
        }
    }

    public static class OpenResult {
        public static final OpenResult SUCCESS = new OpenResult();
        private final String errorMessage;
        private final boolean success;

        public OpenResult(String errorMessage) {
            if (errorMessage == null) {
                errorMessage = "error";
            }
            this.success = false;
            this.errorMessage = errorMessage;
        }

        public OpenResult() {
            this.success = true;
            this.errorMessage = null;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String toString() {
            return "FileOpenResult [success=" + this.success + ", errorMessage=" + this.errorMessage + "]";
        }
    }
}

