/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.oscim.tiling.source.mapfile.Deserializer;
import org.oscim.tiling.source.mapfile.IndexCacheEntryKey;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;
import org.oscim.utils.LRUCache;

class IndexCache {
    private static final int INDEX_ENTRIES_PER_BLOCK = 128;
    private static final Logger LOG = Logger.getLogger(IndexCache.class.getName());
    private static final int SIZE_OF_INDEX_BLOCK = 640;
    private final Map<IndexCacheEntryKey, byte[]> map;
    private final FileChannel fileChannel;

    IndexCache(FileChannel inputChannel, int capacity) {
        this.fileChannel = inputChannel;
        this.map = Collections.synchronizedMap(new LRUCache(capacity));
    }

    void destroy() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getIndexEntry(SubFileParameter subFileParameter, long blockNumber) {
        try {
            if (blockNumber >= subFileParameter.numberOfBlocks) {
                return -1L;
            }
            long indexBlockNumber = blockNumber / 128L;
            IndexCacheEntryKey indexCacheEntryKey = new IndexCacheEntryKey(subFileParameter, indexBlockNumber);
            byte[] indexBlock = this.map.get(indexCacheEntryKey);
            if (indexBlock == null) {
                long indexBlockPosition = subFileParameter.indexStartAddress + indexBlockNumber * 640L;
                int remainingIndexSize = (int)(subFileParameter.indexEndAddress - indexBlockPosition);
                int indexBlockSize = Math.min(640, remainingIndexSize);
                indexBlock = new byte[indexBlockSize];
                ByteBuffer indexBlockWrapper = ByteBuffer.wrap(indexBlock, 0, indexBlockSize);
                FileChannel fileChannel = this.fileChannel;
                synchronized (fileChannel) {
                    this.fileChannel.position(indexBlockPosition);
                    if (this.fileChannel.read(indexBlockWrapper) != indexBlockSize) {
                        LOG.warning("reading the current index block has failed");
                        return -1L;
                    }
                }
                this.map.put(indexCacheEntryKey, indexBlock);
            }
            long indexEntryInBlock = blockNumber % 128L;
            int addressInIndexBlock = (int)(indexEntryInBlock * 5L);
            return Deserializer.getFiveBytesLong(indexBlock, addressInIndexBlock);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
            return -1L;
        }
    }
}

