/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.OverzoomTileDataSource;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.IMapFileTileSource;
import org.oscim.tiling.source.mapfile.IndexCache;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapFileUtils;
import org.oscim.tiling.source.mapfile.MapInfo;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileHeader;
import org.oscim.tiling.source.mapfile.header.MapFileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFileTileSource
extends TileSource
implements IMapFileTileSource {
    private static final Logger log = LoggerFactory.getLogger(MapFileTileSource.class);
    private static final int INDEX_CACHE_SIZE = 64;
    MapFileHeader fileHeader;
    MapFileInfo fileInfo;
    IndexCache databaseIndexCache;
    boolean experimental;
    File mapFile;
    FileInputStream mapFileInputStream;
    private FileChannel inputChannel;
    private String preferredLanguage;
    private Callback callback;

    public MapFileTileSource() {
        this(2, 20);
    }

    public MapFileTileSource(int zoomMin, int zoomMax) {
        this(zoomMin, zoomMax, 17);
    }

    public MapFileTileSource(int zoomMin, int zoomMax, int overZoom) {
        super(zoomMin, zoomMax, overZoom);
    }

    String extractLocalized(String s) {
        if (this.callback != null) {
            return this.callback.extractLocalized(s);
        }
        return MapFileUtils.extract(s, this.preferredLanguage);
    }

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public boolean setMapFile(String filename) {
        this.setOption("file", filename);
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        return file.canRead();
    }

    public void setMapFileInputStream(FileInputStream fileInputStream) {
        this.mapFileInputStream = fileInputStream;
    }

    @Override
    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @Override
    public TileSource.OpenResult open() {
        if (this.mapFileInputStream == null && !this.options.containsKey("file")) {
            return new TileSource.OpenResult("no map file set");
        }
        try {
            File file = null;
            if (this.mapFileInputStream != null) {
                this.inputChannel = this.mapFileInputStream.getChannel();
            } else {
                file = new File((String)this.options.get("file"));
                if (!file.exists()) {
                    return new TileSource.OpenResult("file does not exist: " + file);
                }
                if (!file.isFile()) {
                    return new TileSource.OpenResult("not a file: " + file);
                }
                if (!file.canRead()) {
                    return new TileSource.OpenResult("cannot read file: " + file);
                }
                FileInputStream fis = new FileInputStream(file);
                this.inputChannel = fis.getChannel();
            }
            long fileSize = this.inputChannel.size();
            ReadBuffer readBuffer = new ReadBuffer(this.inputChannel);
            this.fileHeader = new MapFileHeader();
            TileSource.OpenResult openResult = this.fileHeader.readHeader(readBuffer, fileSize);
            if (!openResult.isSuccess()) {
                this.close();
                return openResult;
            }
            this.fileInfo = this.fileHeader.getMapFileInfo();
            this.mapFile = file;
            this.databaseIndexCache = new IndexCache(this.inputChannel, 64);
            log.debug("File version: " + this.fileInfo.fileVersion);
            return TileSource.OpenResult.SUCCESS;
        }
        catch (IOException e) {
            log.error(e.toString());
            this.close();
            return new TileSource.OpenResult(e.toString());
        }
    }

    @Override
    public ITileDataSource getDataSource() {
        try {
            return new OverzoomTileDataSource(new MapDatabase(this), this.mOverZoom);
        }
        catch (IOException e) {
            log.debug(e.toString());
            return null;
        }
    }

    @Override
    public void close() {
        if (this.inputChannel != null) {
            try {
                this.inputChannel.close();
                this.inputChannel = null;
            }
            catch (IOException e) {
                log.error(e.toString());
            }
        }
        this.fileHeader = null;
        this.fileInfo = null;
        this.mapFile = null;
        if (this.databaseIndexCache != null) {
            this.databaseIndexCache.destroy();
            this.databaseIndexCache = null;
        }
    }

    public MapInfo getMapInfo() {
        return this.fileInfo;
    }

    public static interface Callback {
        public String extractLocalized(String var1);
    }
}

