/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.ArrayList;
import java.util.List;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.TileDataSink;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapReadResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiMapDatabase
implements ITileDataSource {
    private static final Logger log = LoggerFactory.getLogger(MultiMapDatabase.class);
    private final boolean deduplicate;
    private final List<MapDatabase> mapDatabases = new ArrayList<MapDatabase>();

    public MultiMapDatabase() {
        this(false);
    }

    public MultiMapDatabase(boolean deduplicate) {
        this.deduplicate = deduplicate;
    }

    public boolean add(MapDatabase mapDatabase) {
        if (this.mapDatabases.contains(mapDatabase)) {
            throw new IllegalArgumentException("Duplicate map database");
        }
        return this.mapDatabases.add(mapDatabase);
    }

    @Override
    public void query(MapTile tile, ITileDataSink sink) {
        try {
            boolean deduplicate = this.deduplicate;
            if (deduplicate) {
                int n = 0;
                for (MapDatabase mapDatabase : this.mapDatabases) {
                    if (mapDatabase.supportsTile(tile) && ++n > 1) break;
                }
                deduplicate = n > 1;
            }
            TileDataSink dataSink = new TileDataSink(sink);
            int n = this.mapDatabases.size();
            for (int i = 0; i < n; ++i) {
                MapDatabase mapDatabase = this.mapDatabases.get(i);
                if (!mapDatabase.supportsTile(tile)) continue;
                mapDatabase.setDeduplicate(deduplicate);
                dataSink.level = i + 1;
                dataSink.levels = n;
                mapDatabase.query(tile, dataSink);
            }
            sink.completed(QueryResult.SUCCESS);
        }
        catch (Throwable t) {
            log.error(t.toString(), t);
            sink.completed(QueryResult.FAILED);
        }
    }

    @Override
    public void dispose() {
        for (MapDatabase mapDatabase : this.mapDatabases) {
            mapDatabase.dispose();
        }
    }

    @Override
    public void cancel() {
        for (MapDatabase mapDatabase : this.mapDatabases) {
            mapDatabase.cancel();
        }
    }

    public MapReadResult readLabels(Tile tile, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readLabels(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public MapReadResult readLabels(Tile upperLeft, Tile lowerRight, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readLabels(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public MapReadResult readMapData(Tile tile, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readMapData(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public MapReadResult readMapData(Tile upperLeft, Tile lowerRight, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readMapData(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public MapReadResult readPoiData(Tile tile, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readPoiData(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public MapReadResult readPoiData(Tile upperLeft, Tile lowerRight, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readPoiData(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public boolean supportsTile(Tile tile) {
        for (MapDatabase mdb : this.mapDatabases) {
            if (!mdb.supportsTile(tile)) continue;
            return true;
        }
        return false;
    }
}

