/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;

public final class OSMUtils {
    private static final Set<String> areaKeys = new HashSet<String>(Arrays.asList("building", "natural", "landuse", "amenity", "leisure", "aeroway", "highway", "barrier", "railway", "area"));

    public static boolean isArea(MapElement mapElement) {
        boolean result = true;
        for (int i = 0; i < mapElement.tags.size(); ++i) {
            String value;
            Tag tag = mapElement.tags.get(i);
            String key = tag.key.toLowerCase(Locale.ENGLISH);
            if (!areaKeys.contains(key)) continue;
            if ("building".equals(key) || "natural".equals(key) || "landuse".equals(key) || "amenity".equals(key) || "leisure".equals(key) || "aeroway".equals(key)) {
                return true;
            }
            if ("highway".equals(key) || "barrier".equals(key)) {
                result = false;
                continue;
            }
            if ("railway".equals(key)) {
                value = tag.value.toLowerCase(Locale.ENGLISH);
                if (!"rail".equals(value) && !"tram".equals(value) && !"subway".equals(value) && !"narrow_gauge".equals(value) && !"light_rail".equals(value) && !"construction".equals(value) && !"preserved".equals(value) && !"monorail".equals(value)) continue;
                result = false;
                continue;
            }
            if (!"area".equals(key)) continue;
            value = tag.value.toLowerCase(Locale.ENGLISH);
            if ("yes".equals(value) || "y".equals(value) || "true".equals(value)) {
                return true;
            }
            if (!"no".equals(value) && !"n".equals(value) && !"false".equals(value)) continue;
            return false;
        }
        return result;
    }

    private OSMUtils() {
    }
}

