/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.oscimap4;

import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.OverzoomTileDataSource;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.oscimap4.TileDecoder;

public class OSciMap4TileSource
extends UrlTileSource {
    private static final String DEFAULT_URL = "https://oscim.ogiqvo.com/tiles/vtm";
    private static final String DEFAULT_PATH = "/{Z}/{X}/{Y}.vtm";

    public static Builder<?> builder() {
        return new Builder();
    }

    protected OSciMap4TileSource(Builder<?> builder) {
        super((UrlTileSource.Builder<?>)builder);
    }

    public OSciMap4TileSource() {
        this(OSciMap4TileSource.builder());
    }

    public OSciMap4TileSource(String urlString) {
        this((Builder)OSciMap4TileSource.builder().url(urlString));
    }

    @Override
    public ITileDataSource getDataSource() {
        return new OverzoomTileDataSource(new UrlTileDataSource(this, new TileDecoder(), this.getHttpEngine()), this.mOverZoom);
    }

    public static class Builder<T extends Builder<T>>
    extends UrlTileSource.Builder<T> {
        public Builder() {
            super(OSciMap4TileSource.DEFAULT_URL, OSciMap4TileSource.DEFAULT_PATH);
            this.overZoom(17);
        }

        @Override
        public OSciMap4TileSource build() {
            return new OSciMap4TileSource(this);
        }
    }
}

