/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

public class TessJNI {
    private long inst;

    public TessJNI() {
        this.inst = TessJNI.newTess(0);
    }

    public TessJNI(int bucketSize) {
        this.inst = TessJNI.newTess(bucketSize);
    }

    protected void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.inst != 0L) {
            TessJNI.freeTess(this.inst);
            this.inst = 0L;
        }
    }

    protected long instance() {
        return this.inst;
    }

    public void addContour2D(float[] points) {
        this.addContour2D(points, 0, points.length >> 1);
    }

    public void addContour2D(float[] points, int offset, int length) {
        if (length < 6) {
            return;
        }
        if (length % 2 != 0 || offset % 2 != 0 || points.length >> 1 < offset + length) {
            throw new IllegalArgumentException("Invalid input: length:" + length + ", offset:" + offset + ", points.length:" + points.length);
        }
        TessJNI.addContour(this.inst, 2, points, 8, offset, length);
    }

    public void addContour2D(int[] index, float[] contour) {
        TessJNI.addMultiContour2D(this.inst, index, contour, 0, index.length);
    }

    public void addContour2D(int[] index, float[] contour, int idxStart, int idxEnd) {
        TessJNI.addMultiContour2D(this.inst, index, contour, idxStart, idxEnd);
    }

    public boolean tesselate() {
        return TessJNI.tessContour2D(this.inst, 2, 0, 3, 2) == 1;
    }

    public boolean tesselate(int windingRule, int elementType) {
        return TessJNI.tessContour2D(this.inst, windingRule, elementType, 3, 2) == 1;
    }

    public int getVertexCount() {
        return TessJNI.getVertexCount(this.inst);
    }

    public int getElementCount() {
        return TessJNI.getElementCount(this.inst);
    }

    public void getVertices(float[] out, int offset, int length) {
        TessJNI.getVertices(this.inst, out, offset, length);
    }

    public void getVertices(short[] out, int offset, int length, float scale) {
        TessJNI.getVerticesS(this.inst, out, offset, length, scale);
    }

    public void getElements(int[] out, int offset, int length) {
        TessJNI.getElements(this.inst, out, offset, length);
    }

    public void getElements(short[] out, int offset, int length) {
        TessJNI.getElementsS(this.inst, out, offset, length);
    }

    public void getVertexIndices(int[] out, int offset, int length) {
        TessJNI.getVertexIndices(this.inst, out, offset, length);
    }

    public void getElementsWithInputVertexIds(short[] dst, int dstOffset, int offset, int length) {
        TessJNI.getElementsWithInputVertexIds(this.inst, dst, dstOffset, offset, length);
    }

    static native long newTess(int var0);

    static native void freeTess(long var0);

    static native void addContour(long var0, int var2, float[] var3, int var4, int var5, int var6);

    static native void addMultiContour2D(long var0, int[] var2, float[] var3, int var4, int var5);

    static native int tessContour2D(long var0, int var2, int var3, int var4, int var5);

    static native int getVertexCount(long var0);

    static native boolean getVertices(long var0, float[] var2, int var3, int var4);

    static native void getVerticesS(long var0, short[] var2, int var3, int var4, float var5);

    static native boolean getVertexIndices(long var0, int[] var2, int var3, int var4);

    static native int getElementCount(long var0);

    static native boolean getElements(long var0, int[] var2, int var3, int var4);

    static native void getElementsS(long var0, short[] var2, int var3, int var4);

    static native void getElementsWithInputVertexIds(long var0, short[] var2, int var3, int var4, int var5);

    public static final class WindingRule {
        public static final int ODD = 0;
        public static final int NONZERO = 1;
        public static final int POSITIVE = 2;
        public static final int NEGATIVE = 3;
        public static final int ABS_GEQ_TWO = 4;
    }

    public static final class ElementType {
        public static final int POLYGONS = 0;
        public static final int CONNECTED_POLYGONS = 1;
        public static final int BOUNDARY_CONTOURS = 2;
    }
}

