/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.PointF;

public class PolyLabel {
    public static float PRECISION = 5.0f;
    private static final float SQRT2 = (float)Math.sqrt(2.0);

    public static PointF get(GeometryBuffer polygon) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        Cell bestCell = PolyLabel.getCentroidCell(polygon);
        if (Float.isNaN(bestCell.x) || Float.isNaN(bestCell.y)) {
            return new PointF(-1.0f, -1.0f);
        }
        int n = polygon.index[0];
        int i = 0;
        while (i < n) {
            float x = polygon.points[i++];
            float y = polygon.points[i++];
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        float width = maxX - minX;
        float height = maxY - minY;
        float cellSize = Math.min(width, height);
        float h = cellSize / 2.0f;
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(1, new MaxComparator());
        for (float x = minX; x < maxX; x += cellSize) {
            for (float y = minY; y < maxY; y += cellSize) {
                cellQueue.add(new Cell(x + h, y + h, h, polygon));
            }
        }
        Cell bboxCell = new Cell(minX + width / 2.0f, minY + height / 2.0f, 0.0f, polygon);
        if (bboxCell.d > bestCell.d) {
            bestCell = bboxCell;
        }
        while (!cellQueue.isEmpty()) {
            Cell cell = (Cell)cellQueue.remove();
            if (cell.d > bestCell.d) {
                bestCell = cell;
            }
            if (cell.max - bestCell.d <= PRECISION) continue;
            h = cell.h / 2.0f;
            cellQueue.add(new Cell(cell.x - h, cell.y - h, h, polygon));
            cellQueue.add(new Cell(cell.x + h, cell.y - h, h, polygon));
            cellQueue.add(new Cell(cell.x - h, cell.y + h, h, polygon));
            cellQueue.add(new Cell(cell.x + h, cell.y + h, h, polygon));
        }
        return new PointF(bestCell.x, bestCell.y);
    }

    private static float pointToPolygonDist(float x, float y, GeometryBuffer polygon) {
        boolean inside = false;
        float minDistSq = Float.POSITIVE_INFINITY;
        int pos = 0;
        for (int k = 0; k < polygon.index.length && polygon.index[k] >= 0; ++k) {
            if (polygon.index[k] == 0) continue;
            int n = polygon.index[k];
            int j = n - 2;
            for (int i = 0; i < n; i += 2) {
                float by;
                float ax = polygon.points[pos + i];
                float ay = polygon.points[pos + i + 1];
                float bx = polygon.points[pos + j];
                if (ay > y ^ (by = polygon.points[pos + j + 1]) > y && x < (bx - ax) * (y - ay) / (by - ay) + ax) {
                    inside = !inside;
                }
                minDistSq = Math.min(minDistSq, PolyLabel.getSegDistSq(x, y, ax, ay, bx, by));
                j = i;
            }
            pos += polygon.index[k];
        }
        return (float)((double)(inside ? 1 : -1) * Math.sqrt(minDistSq));
    }

    private static Cell getCentroidCell(GeometryBuffer polygon) {
        float area = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        int n = polygon.index[0];
        int j = n - 2;
        for (int i = 0; i < n; i += 2) {
            float ax = polygon.points[i];
            float ay = polygon.points[i + 1];
            float bx = polygon.points[j];
            float by = polygon.points[j + 1];
            float f = ax * by - bx * ay;
            x += (ax + bx) * f;
            y += (ay + by) * f;
            area += f * 3.0f;
            j = i;
        }
        return new Cell(x / area, y / area, 0.0f, polygon);
    }

    private static float getSegDistSq(float px, float py, float ax, float ay, float bx, float by) {
        float x = ax;
        float y = ay;
        float dx = bx - x;
        float dy = by - y;
        if (dx != 0.0f || dy != 0.0f) {
            float t = ((px - x) * dx + (py - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0f) {
                x = bx;
                y = by;
            } else if (t > 0.0f) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = px - x;
        dy = py - y;
        return dx * dx + dy * dy;
    }

    private static class Cell {
        final float x;
        final float y;
        final float h;
        final float d;
        final float max;

        Cell(float x, float y, float h, GeometryBuffer polygon) {
            this.x = x;
            this.y = y;
            this.h = h;
            this.d = PolyLabel.pointToPolygonDist(x, y, polygon);
            this.max = this.d + this.h * SQRT2;
        }
    }

    private static class MaxComparator
    implements Comparator<Cell> {
        private MaxComparator() {
        }

        @Override
        public int compare(Cell a, Cell b) {
            return Float.compare(b.max, a.max);
        }
    }
}

