/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.util.List;
import org.oscim.core.GeoPoint;

public class BoundingBox {
    private static final double CONVERSION_FACTOR = 1000000.0;
    public int maxLatitudeE6;
    public int maxLongitudeE6;
    public int minLatitudeE6;
    public int minLongitudeE6;

    public BoundingBox(int minLatitudeE6, int minLongitudeE6, int maxLatitudeE6, int maxLongitudeE6) {
        this.minLatitudeE6 = minLatitudeE6;
        this.minLongitudeE6 = minLongitudeE6;
        this.maxLatitudeE6 = maxLatitudeE6;
        this.maxLongitudeE6 = maxLongitudeE6;
    }

    public BoundingBox(double minLatitude, double minLongitude, double maxLatitude, double maxLongitude) {
        this.minLatitudeE6 = (int)(minLatitude * 1000000.0);
        this.minLongitudeE6 = (int)(minLongitude * 1000000.0);
        this.maxLatitudeE6 = (int)(maxLatitude * 1000000.0);
        this.maxLongitudeE6 = (int)(maxLongitude * 1000000.0);
    }

    public BoundingBox(List<GeoPoint> geoPoints) {
        int minLat = Integer.MAX_VALUE;
        int minLon = Integer.MAX_VALUE;
        int maxLat = Integer.MIN_VALUE;
        int maxLon = Integer.MIN_VALUE;
        for (GeoPoint geoPoint : geoPoints) {
            minLat = Math.min(minLat, geoPoint.latitudeE6);
            minLon = Math.min(minLon, geoPoint.longitudeE6);
            maxLat = Math.max(maxLat, geoPoint.latitudeE6);
            maxLon = Math.max(maxLon, geoPoint.longitudeE6);
        }
        this.minLatitudeE6 = minLat;
        this.minLongitudeE6 = minLon;
        this.maxLatitudeE6 = maxLat;
        this.maxLongitudeE6 = maxLon;
    }

    public boolean contains(GeoPoint geoPoint) {
        return geoPoint.latitudeE6 <= this.maxLatitudeE6 && geoPoint.latitudeE6 >= this.minLatitudeE6 && geoPoint.longitudeE6 <= this.maxLongitudeE6 && geoPoint.longitudeE6 >= this.minLongitudeE6;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (this.maxLatitudeE6 != other.maxLatitudeE6) {
            return false;
        }
        if (this.maxLongitudeE6 != other.maxLongitudeE6) {
            return false;
        }
        if (this.minLatitudeE6 != other.minLatitudeE6) {
            return false;
        }
        return this.minLongitudeE6 == other.minLongitudeE6;
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        return new BoundingBox(Math.min(this.minLatitudeE6, boundingBox.minLatitudeE6), Math.min(this.minLongitudeE6, boundingBox.minLongitudeE6), Math.max(this.maxLatitudeE6, boundingBox.maxLatitudeE6), Math.max(this.maxLongitudeE6, boundingBox.maxLongitudeE6));
    }

    public BoundingBox extendCoordinates(GeoPoint geoPoint) {
        if (this.contains(geoPoint)) {
            return this;
        }
        double minLat = Math.max(-85.05112877980659, Math.min(this.getMinLatitude(), geoPoint.getLatitude()));
        double minLon = Math.max(-180.0, Math.min(this.getMinLongitude(), geoPoint.getLongitude()));
        double maxLat = Math.min(85.05112877980659, Math.max(this.getMaxLatitude(), geoPoint.getLatitude()));
        double maxLon = Math.min(180.0, Math.max(this.getMaxLongitude(), geoPoint.getLongitude()));
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public BoundingBox extendDegrees(double verticalExpansion, double horizontalExpansion) {
        if (verticalExpansion == 0.0 && horizontalExpansion == 0.0) {
            return this;
        }
        if (verticalExpansion < 0.0 || horizontalExpansion < 0.0) {
            throw new IllegalArgumentException("BoundingBox extend operation does not accept negative values");
        }
        double minLat = Math.max(-85.05112877980659, this.getMinLatitude() - verticalExpansion);
        double minLon = Math.max(-180.0, this.getMinLongitude() - horizontalExpansion);
        double maxLat = Math.min(85.05112877980659, this.getMaxLatitude() + verticalExpansion);
        double maxLon = Math.min(180.0, this.getMaxLongitude() + horizontalExpansion);
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public BoundingBox extendMargin(float margin) {
        if (margin == 1.0f) {
            return this;
        }
        if (margin <= 0.0f) {
            throw new IllegalArgumentException("BoundingBox extend operation does not accept negative or zero values");
        }
        double verticalExpansion = (this.getLatitudeSpan() * (double)margin - this.getLatitudeSpan()) * 0.5;
        double horizontalExpansion = (this.getLongitudeSpan() * (double)margin - this.getLongitudeSpan()) * 0.5;
        double minLat = Math.max(-85.05112877980659, this.getMinLatitude() - verticalExpansion);
        double minLon = Math.max(-180.0, this.getMinLongitude() - horizontalExpansion);
        double maxLat = Math.min(85.05112877980659, this.getMaxLatitude() + verticalExpansion);
        double maxLon = Math.min(180.0, this.getMaxLongitude() + horizontalExpansion);
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public BoundingBox extendMeters(int meters) {
        if (meters == 0) {
            return this;
        }
        if (meters < 0) {
            throw new IllegalArgumentException("BoundingBox extend operation does not accept negative values");
        }
        double verticalExpansion = GeoPoint.latitudeDistance(meters);
        double horizontalExpansion = GeoPoint.longitudeDistance(meters, Math.max(Math.abs(this.getMinLatitude()), Math.abs(this.getMaxLatitude())));
        double minLat = Math.max(-85.05112877980659, this.getMinLatitude() - verticalExpansion);
        double minLon = Math.max(-180.0, this.getMinLongitude() - horizontalExpansion);
        double maxLat = Math.min(85.05112877980659, this.getMaxLatitude() + verticalExpansion);
        double maxLon = Math.min(180.0, this.getMaxLongitude() + horizontalExpansion);
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public String format() {
        return "" + (double)this.minLatitudeE6 / 1000000.0 + ',' + (double)this.minLongitudeE6 / 1000000.0 + ',' + (double)this.maxLatitudeE6 / 1000000.0 + ',' + (double)this.maxLongitudeE6 / 1000000.0;
    }

    public GeoPoint getCenterPoint() {
        int latitudeOffset = (this.maxLatitudeE6 - this.minLatitudeE6) / 2;
        int longitudeOffset = (this.maxLongitudeE6 - this.minLongitudeE6) / 2;
        return new GeoPoint(this.minLatitudeE6 + latitudeOffset, this.minLongitudeE6 + longitudeOffset);
    }

    public double getLatitudeSpan() {
        return this.getMaxLatitude() - this.getMinLatitude();
    }

    public double getLongitudeSpan() {
        return this.getMaxLongitude() - this.getMinLatitude();
    }

    public double getMaxLatitude() {
        return (double)this.maxLatitudeE6 / 1000000.0;
    }

    public double getMaxLongitude() {
        return (double)this.maxLongitudeE6 / 1000000.0;
    }

    public double getMinLatitude() {
        return (double)this.minLatitudeE6 / 1000000.0;
    }

    public double getMinLongitude() {
        return (double)this.minLongitudeE6 / 1000000.0;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.maxLatitudeE6;
        result = 31 * result + this.maxLongitudeE6;
        result = 31 * result + this.minLatitudeE6;
        result = 31 * result + this.minLongitudeE6;
        return result;
    }

    public boolean intersects(BoundingBox boundingBox) {
        if (this == boundingBox) {
            return true;
        }
        return this.getMaxLatitude() >= boundingBox.getMinLatitude() && this.getMaxLongitude() >= boundingBox.getMinLongitude() && this.getMinLatitude() <= boundingBox.getMaxLatitude() && this.getMinLongitude() <= boundingBox.getMaxLongitude();
    }

    public String toString() {
        return "BoundingBox [minLat=" + this.minLatitudeE6 + ", minLon=" + this.minLongitudeE6 + ", maxLat=" + this.maxLatitudeE6 + ", maxLon=" + this.maxLongitudeE6 + "]";
    }
}

