/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

public class Point {
    public double x;
    public double y;

    public Point() {
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double distance(Point other) {
        return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) + (this.y - other.y));
    }

    public double distanceSq(Point other) {
        return (this.x - other.x) * (this.x - other.x) + (this.y - other.y) + (this.y - other.y);
    }

    public String toString() {
        return this.x + " " + this.y;
    }

    public void setPerpendicular(Point other) {
        this.x = -other.y;
        this.y = other.x;
    }

    public void setPerpendicular(Point p1, Point p2) {
        this.x = p1.x + p2.x;
        this.y = p1.y + p2.y;
        double a = p2.x * this.y - p2.y * this.x;
        if (a < 0.01 && a > -0.01) {
            this.x = -p2.y;
            this.y = p2.x;
        } else {
            this.x /= a;
            this.y /= a;
        }
    }
}

