/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.backend.canvas.Color;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.layers.tile.buildings.S3DBLayer;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.TileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class S3DBTileLoader
extends TileLoader {
    static final Logger log = LoggerFactory.getLogger(S3DBTileLoader.class);
    private final ITileDataSource mTileDataSource;
    private ExtrusionBucket mParts;
    private ExtrusionBucket mRoofs;
    private float mGroundScale;
    static MapElement mTilePlane = new MapElement();
    String COLOR_KEY = "c";
    String MATERIAL_KEY = "m";
    String ROOF_KEY = "roof";
    String ROOF_SHAPE_KEY = "roof:shape";

    public S3DBTileLoader(TileManager tileManager, TileSource tileSource) {
        super(tileManager);
        this.mTileDataSource = tileSource.getDataSource();
    }

    @Override
    public void dispose() {
        this.mTileDataSource.dispose();
    }

    @Override
    public void cancel() {
        this.mTileDataSource.cancel();
    }

    @Override
    protected boolean loadTile(MapTile tile) {
        this.mTile = tile;
        try {
            this.mTileDataSource.query(this.mTile, this);
        }
        catch (Exception e) {
            log.debug("{}", (Throwable)e);
            return false;
        }
        return true;
    }

    private void initTile(MapTile tile) {
        double lat = MercatorProjection.toLatitude(tile.y);
        this.mGroundScale = (float)MercatorProjection.groundResolution(lat, 1 << this.mTile.zoomLevel);
        this.mRoofs = new ExtrusionBucket(0, this.mGroundScale, Color.get(247, 249, 250));
        this.mParts = new ExtrusionBucket(0, this.mGroundScale, Color.get(255, 254, 252));
        this.mRoofs.next = this.mParts;
        BuildingLayer.get(tile).setBuckets(this.mRoofs);
        this.process(mTilePlane);
    }

    @Override
    public void process(MapElement element) {
        ExtrusionBucket l;
        if (element.type != GeometryBuffer.GeometryType.TRIS) {
            log.debug("wrong type " + (Object)((Object)element.type));
            return;
        }
        if (this.mParts == null) {
            this.initTile(this.mTile);
        }
        boolean isRoof = element.tags.containsKey(this.ROOF_KEY);
        int c = 0;
        if (element.tags.containsKey(this.COLOR_KEY)) {
            c = S3DBLayer.getColor(element.tags.getValue(this.COLOR_KEY), isRoof);
        }
        if (c == 0 && element.tags.containsKey(this.MATERIAL_KEY)) {
            c = S3DBLayer.getMaterialColor(element.tags.getValue(this.MATERIAL_KEY), isRoof);
        }
        if (c == 0) {
            String roofShape = element.tags.getValue(this.ROOF_SHAPE_KEY);
            if (isRoof && (roofShape == null || "flat".equals(roofShape))) {
                this.mRoofs.add(element);
            } else {
                this.mParts.add(element);
            }
            return;
        }
        for (l = this.mParts; l != null; l = l.next()) {
            if (l.color != c) continue;
            l.add(element);
            return;
        }
        l = new ExtrusionBucket(0, this.mGroundScale, c);
        l.next = this.mParts.next;
        this.mParts.next = l;
        l.add(element);
    }

    @Override
    public void completed(QueryResult result) {
        this.mParts = null;
        this.mRoofs = null;
        super.completed(result);
    }

    static {
        MapElement g = mTilePlane = new MapElement();
        g.type = GeometryBuffer.GeometryType.TRIS;
        g.points = new float[]{0.0f, 0.0f, 0.0f, 4096.0f, 0.0f, 0.0f, 0.0f, 4096.0f, 0.0f, 4096.0f, 4096.0f, 0.0f};
        g.index = new int[]{0, 1, 2, 2, 1, 3};
        S3DBTileLoader.mTilePlane.tags.add(new Tag("c", "transparent"));
    }
}

