/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.core.Box;
import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.renderer.GLMatrix;
import org.oscim.utils.FastMath;

public class Viewport {
    public static final int MAX_ZOOMLEVEL = 20;
    public static final int MIN_ZOOMLEVEL = 2;
    public static final float MIN_TILT = 0.0f;
    public static final float MAX_TILT = 65.0f;
    protected double mMaxScale = 1048576.0;
    protected double mMinScale = 4.0;
    protected float mMinTilt = 0.0f;
    protected float mMaxTilt = 65.0f;
    protected float mMinBearing = -180.0f;
    protected float mMaxBearing = 180.0f;
    protected double mMinX = 0.0;
    protected double mMaxX = 1.0;
    protected double mMinY = 0.0;
    protected double mMaxY = 1.0;
    protected final MapPosition mPos = new MapPosition();
    protected final GLMatrix mProjMatrix = new GLMatrix();
    protected final GLMatrix mProjMatrixUnscaled = new GLMatrix();
    protected final GLMatrix mProjMatrixInverse = new GLMatrix();
    protected final GLMatrix mRotationMatrix = new GLMatrix();
    protected final GLMatrix mViewMatrix = new GLMatrix();
    protected final GLMatrix mViewProjMatrix = new GLMatrix();
    protected final GLMatrix mUnprojMatrix = new GLMatrix();
    protected final GLMatrix mTmpMatrix = new GLMatrix();
    protected final Point mMovePoint = new Point();
    protected final float[] mv = new float[4];
    protected final float[] mu = new float[4];
    protected final float[] mViewCoords = new float[8];
    protected float mHeight;
    protected float mWidth;
    public static final float VIEW_DISTANCE = 3.0f;
    public static final float VIEW_NEAR = 1.0f;
    public static final float VIEW_FAR = 8.0f;
    public static final float VIEW_SCALE = 0.16666667f;

    public Viewport() {
        this.mPos.scale = this.mMinScale;
        this.mPos.x = 0.5;
        this.mPos.y = 0.5;
        this.mPos.bearing = 0.0f;
        this.mPos.tilt = 0.0f;
    }

    public double limitScale(double scale) {
        if (scale > this.mMaxScale) {
            return this.mMaxScale;
        }
        if (scale < this.mMinScale) {
            return this.mMinScale;
        }
        return scale;
    }

    public float limitTilt(float tilt) {
        if (tilt > this.mMaxTilt) {
            return this.mMaxTilt;
        }
        if (tilt < this.mMinTilt) {
            return this.mMinTilt;
        }
        return tilt;
    }

    public boolean limitPosition(MapPosition pos) {
        boolean changed = false;
        if (pos.scale > this.mMaxScale) {
            pos.scale = this.mMaxScale;
            changed = true;
        } else if (pos.scale < this.mMinScale) {
            pos.scale = this.mMinScale;
            changed = true;
        }
        if (pos.tilt > this.mMaxTilt) {
            pos.tilt = this.mMaxTilt;
            changed = true;
        } else if (pos.tilt < this.mMinTilt) {
            pos.tilt = this.mMinTilt;
            changed = true;
        }
        if (pos.bearing > this.mMaxBearing) {
            pos.bearing = this.mMaxBearing;
            changed = true;
        } else if (pos.bearing < this.mMinBearing) {
            pos.bearing = this.mMinBearing;
            changed = true;
        }
        if (pos.x > this.mMaxX) {
            pos.x = this.mMaxX;
            changed = true;
        } else if (pos.x < this.mMinX) {
            pos.x = this.mMinX;
            changed = true;
        }
        if (pos.y > this.mMaxY) {
            pos.y = this.mMaxY;
            changed = true;
        } else if (pos.y < this.mMinY) {
            pos.y = this.mMinY;
            changed = true;
        }
        return changed;
    }

    public boolean getMapPosition(MapPosition pos) {
        boolean changed = pos.scale != this.mPos.scale || pos.x != this.mPos.x || pos.y != this.mPos.y || pos.bearing != this.mPos.bearing || pos.tilt != this.mPos.tilt;
        pos.bearing = this.mPos.bearing;
        pos.tilt = this.mPos.tilt;
        pos.x = this.mPos.x;
        pos.y = this.mPos.y;
        pos.scale = this.mPos.scale;
        pos.zoomLevel = FastMath.log2((int)this.mPos.scale);
        return changed;
    }

    public void getMapExtents(float[] box, float add) {
        this.unproject(1.0f, -1.0f, box, 0);
        this.unproject(-1.0f, -1.0f, box, 2);
        this.unproject(-1.0f, 1.0f, box, 4);
        this.unproject(1.0f, 1.0f, box, 6);
        if (add == 0.0f) {
            return;
        }
        for (int i = 0; i < 8; i += 2) {
            float x = box[i];
            float y = box[i + 1];
            float len = (float)Math.sqrt(x * x + y * y);
            int n = i + 0;
            box[n] = box[n] + x / len * add;
            int n2 = i + 1;
            box[n2] = box[n2] + y / len * add;
        }
    }

    protected void unproject(float x, float y, float[] coords, int position) {
        this.mv[0] = x;
        this.mv[1] = y;
        this.mv[2] = -1.0f;
        this.mUnprojMatrix.prj(this.mv);
        double nx = this.mv[0];
        double ny = this.mv[1];
        double nz = this.mv[2];
        this.mv[0] = x;
        this.mv[1] = y;
        this.mv[2] = 1.0f;
        this.mUnprojMatrix.prj(this.mv);
        double fx = this.mv[0];
        double fy = this.mv[1];
        double fz = this.mv[2];
        double dx = fx - nx;
        double dy = fy - ny;
        double dz = fz - nz;
        double dist = -nz / dz;
        coords[position + 0] = (float)(nx + dist * dx);
        coords[position + 1] = (float)(ny + dist * dy);
    }

    public Box getBBox(Box box, int expand) {
        if (box == null) {
            box = new Box();
        }
        float[] coords = this.mViewCoords;
        this.getMapExtents(coords, expand);
        box.xmin = coords[0];
        box.xmax = coords[0];
        box.ymin = coords[1];
        box.ymax = coords[1];
        for (int i = 2; i < 8; i += 2) {
            box.xmin = Math.min(box.xmin, (double)coords[i]);
            box.xmax = Math.max(box.xmax, (double)coords[i]);
            box.ymin = Math.min(box.ymin, (double)coords[i + 1]);
            box.ymax = Math.max(box.ymax, (double)coords[i + 1]);
        }
        double cs = this.mPos.scale * (double)Tile.SIZE;
        double cx = this.mPos.x * cs;
        double cy = this.mPos.y * cs;
        box.xmin = (cx + box.xmin) / cs;
        box.xmax = (cx + box.xmax) / cs;
        box.ymin = (cy + box.ymin) / cs;
        box.ymax = (cy + box.ymax) / cs;
        return box;
    }

    public GeoPoint fromScreenPoint(float x, float y) {
        this.fromScreenPoint(x, y, this.mMovePoint);
        return new GeoPoint(MercatorProjection.toLatitude(this.mMovePoint.y), MercatorProjection.toLongitude(this.mMovePoint.x));
    }

    protected void unprojectScreen(double x, double y, float[] out) {
        float mx = (float)(1.0 - x / (double)this.mWidth * 2.0);
        float my = (float)(1.0 - y / (double)this.mHeight * 2.0);
        this.unproject(-mx, my, out, 0);
    }

    public void fromScreenPoint(double x, double y, Point out) {
        this.unprojectScreen(x, y, this.mu);
        double cs = this.mPos.scale * (double)Tile.SIZE;
        double cx = this.mPos.x * cs;
        double cy = this.mPos.y * cs;
        double dx = cx + (double)this.mu[0];
        double dy = cy + (double)this.mu[1];
        dx /= cs;
        dy /= cs;
        while (dx > 1.0) {
            dx -= 1.0;
        }
        while (dx < 0.0) {
            dx += 1.0;
        }
        if (dy > 1.0) {
            dy = 1.0;
        } else if (dy < 0.0) {
            dy = 0.0;
        }
        out.x = dx;
        out.y = dy;
    }

    public void toScreenPoint(GeoPoint geoPoint, Point out) {
        this.toScreenPoint(geoPoint, true, out);
    }

    public void toScreenPoint(GeoPoint geoPoint, boolean relativeToCenter, Point out) {
        MercatorProjection.project(geoPoint, out);
        this.toScreenPoint(out.x, out.y, relativeToCenter, out);
    }

    public void toScreenPoint(double x, double y, Point out) {
        this.toScreenPoint(x, y, true, out);
    }

    public void toScreenPoint(double x, double y, boolean relativeToCenter, Point out) {
        double cs = this.mPos.scale * (double)Tile.SIZE;
        double cx = this.mPos.x * cs;
        double cy = this.mPos.y * cs;
        this.mv[0] = (float)(x * cs - cx);
        this.mv[1] = (float)(y * cs - cy);
        this.mv[2] = 0.0f;
        this.mv[3] = 1.0f;
        this.mViewProjMatrix.prj(this.mv);
        out.x = this.mv[0] * (this.mWidth / 2.0f);
        out.y = -(this.mv[1] * (this.mHeight / 2.0f));
        if (!relativeToCenter) {
            out.x += (double)(this.mWidth / 2.0f);
            out.y += (double)(this.mHeight / 2.0f);
        }
    }

    boolean sizeChanged(Viewport viewport) {
        return this.mHeight != viewport.mHeight || this.mWidth != viewport.mWidth;
    }

    protected boolean copy(Viewport viewport) {
        boolean sizeChanged = this.sizeChanged(viewport);
        this.mHeight = viewport.mHeight;
        this.mWidth = viewport.mWidth;
        this.mProjMatrix.copy(viewport.mProjMatrix);
        this.mProjMatrixUnscaled.copy(viewport.mProjMatrixUnscaled);
        this.mProjMatrixInverse.copy(viewport.mProjMatrixInverse);
        this.mUnprojMatrix.copy(viewport.mUnprojMatrix);
        this.mRotationMatrix.copy(viewport.mRotationMatrix);
        this.mViewMatrix.copy(viewport.mViewMatrix);
        this.mViewProjMatrix.copy(viewport.mViewProjMatrix);
        return viewport.getMapPosition(this.mPos) || sizeChanged;
    }

    public double getMaxScale() {
        return this.mMaxScale;
    }

    public void setMaxScale(double maxScale) {
        this.mMaxScale = maxScale;
    }

    public double getMinScale() {
        return this.mMinScale;
    }

    public void setMinScale(double minScale) {
        this.mMinScale = minScale;
    }

    public int getMaxZoomLevel() {
        return FastMath.log2((int)this.mMaxScale);
    }

    public void setMaxZoomLevel(int maxZoomLevel) {
        this.mMaxScale = 1 << maxZoomLevel;
    }

    public int getMinZoomLevel() {
        return FastMath.log2((int)this.mMinScale);
    }

    public void setMinZoomLevel(int minZoomLevel) {
        this.mMinScale = 1 << minZoomLevel;
    }

    public float getMaxTilt() {
        return this.mMaxTilt;
    }

    public void setMaxTilt(float maxTilt) {
        this.mMaxTilt = maxTilt;
    }

    public float getMinTilt() {
        return this.mMinTilt;
    }

    public void setMinTilt(float minTilt) {
        this.mMinTilt = minTilt;
    }

    public float getMaxBearing() {
        return this.mMaxBearing;
    }

    public void setMaxBearing(float maxBearing) {
        this.mMaxBearing = maxBearing;
    }

    public float getMinBearing() {
        return this.mMinBearing;
    }

    public void setMinBearing(float minBearing) {
        this.mMinBearing = minBearing;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public void setMaxX(double maxX) {
        this.mMaxX = maxX;
    }

    public double getMinX() {
        return this.mMinX;
    }

    public void setMinX(double minX) {
        this.mMinX = minX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }

    public void setMaxY(double maxY) {
        this.mMaxY = maxY;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public void setMinY(double minY) {
        this.mMinY = minY;
    }
}

