/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.styles.RenderStyle;

public final class TextStyle
extends RenderStyle<TextStyle> {
    public final String style;
    public final float fontSize;
    public final Paint paint;
    public final Paint stroke;
    public final String textKey;
    public final boolean caption;
    public final float dy;
    public final int priority;
    public float fontHeight;
    public float fontDescent;
    public final Bitmap bitmap;
    public final TextureRegion texture;

    TextStyle(TextBuilder<?> tb) {
        this.style = tb.style;
        this.textKey = tb.textKey;
        this.caption = tb.caption;
        this.dy = tb.dy;
        this.priority = tb.priority;
        this.bitmap = tb.bitmap;
        this.texture = tb.texture;
        this.paint = CanvasAdapter.newPaint();
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.paint.setTypeface(tb.fontFamily, tb.fontStyle);
        this.paint.setColor(tb.fillColor);
        this.paint.setTextSize(tb.fontSize);
        if (tb.strokeWidth > 0.0f) {
            this.stroke = CanvasAdapter.newPaint();
            this.stroke.setStyle(Paint.Style.STROKE);
            this.stroke.setTextAlign(Paint.Align.CENTER);
            this.stroke.setTypeface(tb.fontFamily, tb.fontStyle);
            this.stroke.setColor(tb.strokeColor);
            this.stroke.setStrokeWidth(tb.strokeWidth);
            this.stroke.setTextSize(tb.fontSize);
        } else {
            this.stroke = null;
        }
        this.fontSize = tb.fontSize;
    }

    @Override
    public void dispose() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
    }

    @Override
    public void renderNode(RenderStyle.Callback cb) {
        cb.renderText(this);
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderText(this);
    }

    @Override
    public TextStyle current() {
        return (TextStyle)this.mCurrent;
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
        this.paint.setTextSize(this.fontSize * scaleFactor);
        if (this.stroke != null) {
            this.stroke.setTextSize(this.fontSize * scaleFactor);
        }
        this.fontHeight = this.paint.getFontHeight();
        this.fontDescent = this.paint.getFontDescent();
    }

    public static TextBuilder<?> builder() {
        return new TextBuilder();
    }

    public static class TextBuilder<T extends TextBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public float fontSize;
        public String textKey;
        public boolean caption;
        public float dy;
        public int priority;
        public Bitmap bitmap;
        public TextureRegion texture;
        public Paint.FontFamily fontFamily;
        public Paint.FontStyle fontStyle;

        public T reset() {
            this.fontFamily = Paint.FontFamily.DEFAULT;
            this.fontStyle = Paint.FontStyle.NORMAL;
            this.style = null;
            this.textKey = null;
            this.fontSize = 0.0f;
            this.caption = false;
            this.priority = Integer.MAX_VALUE;
            this.bitmap = null;
            this.texture = null;
            this.fillColor = -16777216;
            this.strokeColor = -16777216;
            this.strokeWidth = 0.0f;
            this.dy = 0.0f;
            return (T)((TextBuilder)this.self());
        }

        public TextBuilder() {
            this.reset();
        }

        @Override
        public TextStyle build() {
            TextStyle t = new TextStyle(this);
            t.fontHeight = t.paint.getFontHeight();
            t.fontDescent = t.paint.getFontDescent();
            return t;
        }

        public TextStyle buildInternal() {
            return new TextStyle(this);
        }

        public T fontSize(float fontSize) {
            this.fontSize = fontSize;
            return (T)((TextBuilder)this.self());
        }

        public T textKey(String textKey) {
            this.textKey = textKey;
            return (T)((TextBuilder)this.self());
        }

        public T isCaption(boolean caption) {
            this.caption = caption;
            return (T)((TextBuilder)this.self());
        }

        public T offsetY(float dy) {
            this.dy = dy;
            return (T)((TextBuilder)this.self());
        }

        public T priority(int priority) {
            this.priority = priority;
            return (T)((TextBuilder)this.self());
        }

        public T bitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return (T)((TextBuilder)this.self());
        }

        public T texture(TextureRegion texture) {
            this.texture = texture;
            return (T)((TextBuilder)this.self());
        }

        public T fontFamily(Paint.FontFamily fontFamily) {
            this.fontFamily = fontFamily;
            return (T)((TextBuilder)this.self());
        }

        public T fontStyle(Paint.FontStyle fontStyle) {
            this.fontStyle = fontStyle;
            return (T)((TextBuilder)this.self());
        }

        public T from(TextBuilder<?> other) {
            this.fontFamily = other.fontFamily;
            this.fontStyle = other.fontStyle;
            this.style = other.style;
            this.textKey = other.textKey;
            this.fontSize = other.fontSize;
            this.caption = other.caption;
            this.priority = other.priority;
            this.bitmap = other.bitmap;
            this.texture = other.texture;
            this.fillColor = other.fillColor;
            this.strokeColor = other.strokeColor;
            this.strokeWidth = other.strokeWidth;
            this.dy = other.dy;
            return (T)((TextBuilder)this.self());
        }

        public TextBuilder<?> from(TextStyle style) {
            this.style = style.style;
            this.textKey = style.textKey;
            this.caption = style.caption;
            this.dy = style.dy;
            this.priority = style.priority;
            this.bitmap = style.bitmap;
            this.texture = style.texture;
            this.fillColor = style.paint.getColor();
            this.fontFamily = Paint.FontFamily.DEFAULT;
            this.fontStyle = Paint.FontStyle.NORMAL;
            this.strokeColor = style.stroke.getColor();
            this.strokeWidth = 2.0f;
            this.fontSize = style.fontSize;
            return (TextBuilder)this.self();
        }
    }
}

