/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.Arrays;
import org.oscim.utils.pool.Inlist;

public class KeyMap<K extends HashItem>
extends Inlist<KeyMap<K>> {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final HashItem[] EMPTY_TABLE = new HashItem[2];
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    HashItem[] table;
    int size;
    private int threshold;
    static final boolean STATS = false;

    public KeyMap() {
        this.table = EMPTY_TABLE;
        this.threshold = -1;
    }

    public KeyMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity: " + capacity);
        }
        if (capacity == 0) {
            HashItem[] tab = EMPTY_TABLE;
            this.table = tab;
            this.threshold = -1;
            return;
        }
        capacity = capacity < 4 ? 4 : (capacity > 0x40000000 ? 0x40000000 : KeyMap.roundUpToPowerOfTwo(capacity));
        this.makeTable(capacity);
    }

    public KeyMap(int capacity, float loadFactor) {
        this(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor: " + loadFactor);
        }
    }

    static int capacityForInitSize(int size) {
        int result = (size >> 1) + size;
        return (result & 0xC0000000) == 0 ? result : 0x40000000;
    }

    void init() {
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public K get(HashItem key) {
        int hash = key.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        HashItem[] tab = this.table;
        HashItem e = tab[hash & tab.length - 1];
        while (e != null) {
            HashItem eKey = e;
            if (eKey == key || e.hash == hash && key.equals(eKey)) {
                return (K)e;
            }
            e = (HashItem)e.next;
        }
        return null;
    }

    public K put(K key) {
        return this.put(key, true);
    }

    public K put(K key, boolean replace) {
        if (((HashItem)key).next != null) {
            throw new IllegalStateException("item not unhooked");
        }
        int hash = KeyMap.secondaryHash(key.hashCode());
        HashItem[] tab = this.table;
        int index = hash & tab.length - 1;
        HashItem e = tab[index];
        while (e != null) {
            if (e.hash == hash && key.equals(e)) {
                if (replace) {
                    tab[index] = Inlist.remove(tab[index], e);
                    tab[index] = Inlist.push(tab[index], key);
                }
                return (K)e;
            }
            e = (HashItem)e.next;
        }
        if (this.size++ > this.threshold) {
            tab = this.doubleCapacity();
            index = hash & tab.length - 1;
        }
        this.addNewEntry(key, hash, index);
        return null;
    }

    public K remove(K key) {
        int hash = KeyMap.secondaryHash(key.hashCode());
        HashItem[] tab = this.table;
        int index = hash & tab.length - 1;
        HashItem e = tab[index];
        HashItem prev = null;
        while (e != null) {
            if (e.hash == hash && key.equals(e)) {
                if (prev == null) {
                    tab[index] = (HashItem)e.next;
                } else {
                    prev.next = e.next;
                }
                e.next = null;
                --this.size;
                return (K)e;
            }
            prev = e;
            e = (HashItem)e.next;
        }
        return null;
    }

    void addNewEntry(K key, int hash, int index) {
        ((HashItem)key).setIndex(hash, this.table[index]);
        this.table[index] = key;
    }

    private HashItem[] makeTable(int newCapacity) {
        HashItem[] newTable = new HashItem[newCapacity];
        this.table = newTable;
        this.threshold = (newCapacity >> 1) + (newCapacity >> 2);
        return newTable;
    }

    private HashItem[] doubleCapacity() {
        HashItem[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity * 2;
        HashItem[] newTable = this.makeTable(newCapacity);
        if (this.size == 0) {
            return newTable;
        }
        for (int j = 0; j < oldCapacity; ++j) {
            HashItem e = oldTable[j];
            if (e == null) continue;
            int highBit = e.hash & oldCapacity;
            HashItem broken = null;
            newTable[j | highBit] = e;
            HashItem n = (HashItem)e.next;
            while (n != null) {
                int nextHighBit = n.hash & oldCapacity;
                if (nextHighBit != highBit) {
                    if (broken == null) {
                        newTable[j | nextHighBit] = n;
                    } else {
                        broken.next = n;
                    }
                    broken = e;
                    highBit = nextHighBit;
                }
                e = n;
                n = (HashItem)n.next;
            }
            if (broken == null) continue;
            broken.next = null;
        }
        return newTable;
    }

    void postRemove(HashItem e) {
    }

    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            this.size = 0;
        }
    }

    public K releaseItems() {
        if (this.size == 0) {
            return null;
        }
        boolean collisions = false;
        boolean max = false;
        boolean sum = false;
        HashItem items = null;
        for (HashItem item : this.table) {
            if (item == null) continue;
            this.table[i] = null;
            HashItem last = Inlist.last(item);
            last.next = items;
            items = item;
        }
        Arrays.fill(this.table, null);
        this.size = 0;
        return (K)items;
    }

    private static int secondaryHash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int roundUpToPowerOfTwo(int i) {
        --i;
        i |= i >>> 1;
        i |= i >>> 2;
        i |= i >>> 4;
        i |= i >>> 8;
        i |= i >>> 16;
        return i + 1;
    }

    public static class HashItem
    extends Inlist<HashItem> {
        int hash;

        public void setIndex(int hash, HashItem next) {
            this.hash = hash;
            this.next = next;
        }
    }
}

