/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.util.Arrays;
import org.oscim.core.Tag;
import org.oscim.utils.Utils;

public class TagSet {
    public Tag[] tags;
    public int numTags;

    public TagSet() {
        this.tags = new Tag[10];
    }

    public TagSet(int size) {
        this.tags = new Tag[size];
    }

    public void clear() {
        this.numTags = 0;
    }

    public void clearAndNullTags() {
        Arrays.fill(this.tags, null);
        this.numTags = 0;
    }

    public Tag[] asArray() {
        Tag[] result = new Tag[this.numTags];
        System.arraycopy(this.tags, 0, result, 0, this.numTags);
        return result;
    }

    public Tag get(String key) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, key)) continue;
            return this.tags[i];
        }
        return null;
    }

    public boolean containsKey(String key) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, key)) continue;
            return true;
        }
        return false;
    }

    public String getValue(String key) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, key)) continue;
            return this.tags[i].value;
        }
        return null;
    }

    public void add(Tag tag) {
        if (this.numTags >= this.tags.length) {
            Tag[] tmp = this.tags;
            this.tags = new Tag[this.numTags + 4];
            System.arraycopy(tmp, 0, this.tags, 0, this.numTags);
        }
        this.tags[this.numTags++] = tag;
    }

    public void set(Tag[] tagArray) {
        int newTags = tagArray.length;
        if (newTags > this.tags.length) {
            this.tags = new Tag[tagArray.length];
        }
        System.arraycopy(tagArray, 0, this.tags, 0, newTags);
        this.numTags = newTags;
    }

    public boolean contains(Tag tag) {
        for (int i = 0; i < this.numTags; ++i) {
            Tag t = this.tags[i];
            if (t != tag && (!Utils.equals(t.key, tag.key) || !Utils.equals(t.value, tag.value))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String key, String value) {
        for (int i = 0; i < this.numTags; ++i) {
            if (!Utils.equals(this.tags[i].key, key)) continue;
            return Utils.equals(this.tags[i].value, value);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numTags; ++i) {
            sb.append(this.tags[i]);
        }
        return sb.toString();
    }
}

