/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.bitmap;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.layers.tile.bitmap.BitmapTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.tiling.TileSource;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileLayer
extends TileLayer {
    protected static final Logger log = LoggerFactory.getLogger(BitmapTileLayer.class);
    private static final int CACHE_LIMIT = 40;
    protected final TileSource mTileSource;
    static final int POOL_FILL = 20;
    final TextureItem.TexturePool pool = new TextureItem.TexturePool(20){};

    public BitmapTileLayer(Map map, TileSource tileSource) {
        this(map, tileSource, 40);
    }

    public BitmapTileLayer(Map map, TileSource tileSource, int cacheLimit) {
        super(map, new TileManager(map, cacheLimit), new VectorTileRenderer());
        this.mTileManager.setZoomLevel(tileSource.getZoomLevelMin(), tileSource.getZoomLevelMax());
        this.mTileSource = tileSource;
        this.initLoader(this.getNumLoaders());
    }

    @Override
    public void onMapEvent(Event event, MapPosition pos) {
        super.onMapEvent(event, pos);
        if (event != Map.POSITION_EVENT) {
            return;
        }
        FadeStep[] fade = this.mTileSource.getFadeSteps();
        if (fade == null) {
            return;
        }
        float alpha = 0.0f;
        for (FadeStep f : fade) {
            if (pos.scale < f.scaleStart || pos.scale > f.scaleEnd) continue;
            if (f.alphaStart == f.alphaEnd) {
                alpha = f.alphaStart;
                break;
            }
            double range = f.scaleEnd / f.scaleStart;
            float a = (float)((range - pos.scale / f.scaleStart) / range);
            a = FastMath.clamp(a, 0.0f, 1.0f);
            alpha = a * f.alphaStart + (1.0f - a) * f.alphaEnd;
            break;
        }
        this.tileRenderer().setBitmapAlpha(alpha);
    }

    @Override
    protected TileLoader createLoader() {
        return new BitmapTileLoader(this, this.mTileSource);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.pool.clear();
    }

    public static class FadeStep {
        public final double scaleStart;
        public final double scaleEnd;
        public final float alphaStart;
        public final float alphaEnd;

        public FadeStep(int zoomStart, int zoomEnd, float alphaStart, float alphaEnd) {
            this.scaleStart = 1 << zoomStart;
            this.scaleEnd = 1 << zoomEnd;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }
}

