/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.VectorTileLoader;
import org.oscim.map.Map;
import org.oscim.utils.Utils;

public class OsmTileLayer
extends VectorTileLayer {
    protected static final int MAX_ZOOMLEVEL = 17;
    protected static final int MIN_ZOOMLEVEL = 2;
    protected static final int CACHE_LIMIT = 150;

    public OsmTileLayer(Map map) {
        super(map, 150);
        this.mTileManager.setZoomLevel(2, 17);
    }

    @Override
    protected TileLoader createLoader() {
        return new OsmTileLoader(this);
    }

    static class OsmTileLoader
    extends VectorTileLoader {
        private final TagSet mFilteredTags = new TagSet();
        private static final VectorTileLoader.TagReplacement[] mTagReplacement = new VectorTileLoader.TagReplacement[]{new VectorTileLoader.TagReplacement("name"), new VectorTileLoader.TagReplacement("addr:housenumber"), new VectorTileLoader.TagReplacement("ref"), new VectorTileLoader.TagReplacement("height"), new VectorTileLoader.TagReplacement("min_height")};

        public OsmTileLoader(VectorTileLayer tileLayer) {
            super(tileLayer);
        }

        @Override
        protected TagSet filterTags(TagSet tagSet) {
            Tag[] tags = tagSet.tags;
            this.mFilteredTags.clear();
            int n = tagSet.numTags;
            block0: for (int i = 0; i < n; ++i) {
                Tag t = tags[i];
                for (VectorTileLoader.TagReplacement replacement : mTagReplacement) {
                    if (!Utils.equals(t.key, replacement.key)) continue;
                    this.mFilteredTags.add(replacement.tag);
                    continue block0;
                }
                this.mFilteredTags.add(t);
            }
            return this.mFilteredTags;
        }
    }
}

