/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorTileLoader
extends TileLoader
implements RenderStyle.Callback {
    static final Logger log = LoggerFactory.getLogger(VectorTileLoader.class);
    protected static final double STROKE_INCREASE = Math.sqrt(2.5);
    protected static final byte LAYERS = 11;
    public static final byte STROKE_MIN_ZOOM = 12;
    public static final byte STROKE_MAX_ZOOM = 17;
    protected IRenderTheme renderTheme;
    protected ITileDataSource mTileDataSource;
    protected MapElement mElement;
    protected LineBucket mCurLineBucket;
    protected int mCurBucket;
    protected float mLineScale = 1.0f;
    protected RenderBuckets mBuckets;
    private final VectorTileLayer mTileLayer;
    public static boolean USE_MESH_POLY = false;

    public VectorTileLoader(VectorTileLayer tileLayer) {
        super(tileLayer.getManager());
        this.mTileLayer = tileLayer;
    }

    @Override
    public void dispose() {
        if (this.mTileDataSource != null) {
            this.mTileDataSource.dispose();
        }
    }

    @Override
    public void cancel() {
        if (this.mTileDataSource != null) {
            this.mTileDataSource.cancel();
        }
    }

    @Override
    public boolean loadTile(MapTile tile) {
        if (this.mTileDataSource == null) {
            log.error("no tile source is set");
            return false;
        }
        this.renderTheme = this.mTileLayer.getTheme();
        if (this.renderTheme == null) {
            log.error("no theme is set");
            return false;
        }
        double lat = MercatorProjection.toLatitude(tile.y);
        this.mLineScale = (float)Math.pow(STROKE_INCREASE, tile.zoomLevel - 12);
        if (this.mLineScale < 1.0f) {
            this.mLineScale = 1.0f;
        }
        this.mLineScale *= 0.4f + 0.6f * (float)Math.sin(Math.abs(lat) * (Math.PI / 180));
        this.mBuckets = new RenderBuckets();
        tile.data = this.mBuckets;
        try {
            this.mTileDataSource.query(tile, this);
        }
        catch (NullPointerException e) {
            log.debug("NPE {} {}", (Object)tile, (Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            log.debug("{} {}", (Object)tile, (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void completed(QueryResult result) {
        boolean ok = result == QueryResult.SUCCESS;
        this.mTileLayer.callHooksComplete(this.mTile, ok);
        this.mBuckets.prepare();
        this.clearState();
        super.completed(result);
    }

    protected static int getValidLayer(int layer) {
        if (layer < 0) {
            return 0;
        }
        if (layer >= 11) {
            return 10;
        }
        return layer;
    }

    public void setDataSource(ITileDataSource dataSource) {
        this.dispose();
        this.mTileDataSource = dataSource;
    }

    protected TagSet filterTags(TagSet tagSet) {
        return tagSet;
    }

    @Override
    public void process(MapElement element) {
        if (this.isCanceled() || !this.mTile.state(2)) {
            return;
        }
        if (this.mTileLayer.callProcessHooks(this.mTile, this.mBuckets, element)) {
            return;
        }
        TagSet tags = this.filterTags(element.tags);
        if (tags == null) {
            return;
        }
        this.mElement = element;
        if (element.type == GeometryBuffer.GeometryType.POINT) {
            this.renderNode(this.renderTheme.matchElement(element.type, tags, this.mTile.zoomLevel));
        } else {
            this.mCurBucket = VectorTileLoader.getValidLayer(element.layer) * this.renderTheme.getLevels();
            this.renderWay(this.renderTheme.matchElement(element.type, tags, this.mTile.zoomLevel));
        }
        this.clearState();
    }

    protected void renderWay(RenderStyle[] style) {
        if (style == null) {
            return;
        }
        int n = style.length;
        for (int i = 0; i < n; ++i) {
            style[i].renderWay(this);
        }
    }

    protected void renderNode(RenderStyle[] style) {
        if (style == null) {
            return;
        }
        int n = style.length;
        for (int i = 0; i < n; ++i) {
            style[i].renderNode(this);
        }
    }

    protected void clearState() {
        this.mCurLineBucket = null;
        this.mElement = null;
    }

    @Override
    public void renderWay(LineStyle line, int level) {
        int nLevel = this.mCurBucket + level;
        if (line.outline && this.mCurLineBucket == null) {
            log.debug("missing line for outline! " + this.mElement.tags + " lvl:" + level + " layer:" + this.mElement.layer);
            return;
        }
        if (line.stipple == 0 && line.texture == null) {
            LineBucket lb = this.mBuckets.getLineBucket(nLevel);
            if (lb.line == null) {
                lb.line = line;
                lb.scale = line.fixed ? 1.0f : this.mLineScale;
                lb.setExtents(-16, Tile.SIZE + 16);
            }
            if (line.outline) {
                lb.addOutline(this.mCurLineBucket);
                return;
            }
            lb.addLine(this.mElement);
            this.mCurLineBucket = lb;
        } else {
            LineTexBucket lb = this.mBuckets.getLineTexBucket(nLevel);
            if (lb.line == null) {
                lb.line = line;
                lb.scale = line.fixed ? 1.0f : this.mLineScale;
                lb.setExtents(-16, Tile.SIZE + 16);
            }
            lb.addLine(this.mElement);
        }
    }

    @Override
    public void renderArea(AreaStyle area, int level) {
        if (this.mTile.zoomLevel < area.fadeScale) {
            return;
        }
        int nLevel = this.mCurBucket + level;
        if (USE_MESH_POLY || area.mesh) {
            MeshBucket mb = this.mBuckets.getMeshBucket(nLevel);
            mb.area = area;
            mb.addMesh(this.mElement);
        } else {
            PolygonBucket pb = this.mBuckets.getPolygonBucket(nLevel);
            pb.area = area;
            pb.addPolygon(this.mElement.points, this.mElement.index);
        }
    }

    @Override
    public void renderSymbol(SymbolStyle symbol) {
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, symbol, 0);
    }

    @Override
    public void renderExtrusion(ExtrusionStyle extrusion, int level) {
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, extrusion, level);
    }

    @Override
    public void renderCircle(CircleStyle circle, int level) {
    }

    @Override
    public void renderText(TextStyle text) {
        this.mTileLayer.callThemeHooks(this.mTile, this.mBuckets, this.mElement, text, 0);
    }

    static class TagReplacement {
        String key;
        Tag tag;

        public TagReplacement(String key) {
            this.key = key;
            this.tag = new Tag(key, null);
        }
    }
}

