/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling;

import java.util.HashMap;
import org.oscim.layers.tile.bitmap.BitmapTileLayer;
import org.oscim.tiling.ITileCache;
import org.oscim.tiling.ITileDataSource;

public abstract class TileSource {
    protected int mZoomMin = 0;
    protected int mZoomMax = 20;
    protected int mTileSize = 256;
    protected final Options options = new Options();
    public ITileCache tileCache;
    private BitmapTileLayer.FadeStep[] mFadeSteps;

    protected TileSource() {
    }

    protected TileSource(int zoomMin, int zoomMax) {
        this.mZoomMin = zoomMin;
        this.mZoomMax = zoomMax;
    }

    public TileSource(Builder<?> builder) {
        this.mZoomMin = builder.zoomMin;
        this.mZoomMax = builder.zoomMax;
        this.mFadeSteps = builder.fadeSteps;
        this.mTileSize = builder.tileSize;
    }

    public abstract ITileDataSource getDataSource();

    public abstract OpenResult open();

    public abstract void close();

    public void setCache(ITileCache cache) {
        this.tileCache = cache;
    }

    public int getZoomLevelMax() {
        return this.mZoomMax;
    }

    public int getZoomLevelMin() {
        return this.mZoomMin;
    }

    public BitmapTileLayer.FadeStep[] getFadeSteps() {
        return this.mFadeSteps;
    }

    public int getTileSize() {
        return this.mTileSize;
    }

    public TileSource setOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public String getOption(String key) {
        return (String)this.options.get(key);
    }

    public static class OpenResult {
        public static final OpenResult SUCCESS = new OpenResult();
        private final String errorMessage;
        private final boolean success;

        public OpenResult(String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException("error message must not be null");
            }
            this.success = false;
            this.errorMessage = errorMessage;
        }

        public OpenResult() {
            this.success = true;
            this.errorMessage = null;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String toString() {
            return "FileOpenResult [success=" + this.success + ", errorMessage=" + this.errorMessage + "]";
        }
    }

    public static class Options
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Options)) {
                return false;
            }
            return this.entrySet().equals(((Options)other).entrySet());
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int zoomMin;
        protected int zoomMax;
        protected BitmapTileLayer.FadeStep[] fadeSteps;
        protected int tileSize;

        public T zoomMin(int zoom) {
            this.zoomMin = zoom;
            return this.self();
        }

        public T zoomMax(int zoom) {
            this.zoomMax = zoom;
            return this.self();
        }

        public T fadeSteps(BitmapTileLayer.FadeStep[] fadeSteps) {
            this.fadeSteps = fadeSteps;
            return this.self();
        }

        public T tileSize(int tileSize) {
            this.tileSize = tileSize;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        public abstract TileSource build();
    }
}

