/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HairLineBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(HairLineBucket.class);
    public LineStyle line;

    public HairLineBucket(int level) {
        super(5, true, false);
        this.level = level;
    }

    public void addLine(GeometryBuffer geom) {
        short id = (short)this.numVertices;
        float[] pts = geom.points;
        boolean poly = geom.isPoly();
        int inPos = 0;
        block0: for (int len : geom.index) {
            if (len < 0) break;
            if (len < 4 || poly && len < 6) {
                inPos += len;
                continue;
            }
            int end = inPos + len;
            this.vertexItems.add((short)(pts[inPos++] * 8.0f), (short)(pts[inPos++] * 8.0f));
            short first = id;
            short s = id;
            id = (short)(id + 1);
            this.indiceItems.add(s);
            ++this.numIndices;
            while (inPos < end) {
                this.vertexItems.add((short)(pts[inPos++] * 8.0f), (short)(pts[inPos++] * 8.0f));
                this.indiceItems.add(id);
                ++this.numIndices;
                if (inPos == end) {
                    if (poly) {
                        this.indiceItems.add(id);
                        ++this.numIndices;
                        this.indiceItems.add(first);
                        ++this.numIndices;
                    }
                    id = (short)(id + 1);
                    continue block0;
                }
                short s2 = id;
                id = (short)(id + 1);
                this.indiceItems.add(s2);
                ++this.numIndices;
            }
        }
        this.numVertices = id;
    }

    public static class Renderer {
        static Shader shader;

        static boolean init() {
            shader = new Shader("hairline");
            return true;
        }

        public static RenderBucket draw(RenderBucket l, GLViewport v) {
            GLState.blend(true);
            Shader s = shader;
            s.set(v);
            while (l != null && l.type == 5) {
                HairLineBucket ll = (HairLineBucket)l;
                LineStyle line = ll.line.current();
                GLUtils.setColor(s.uColor, line.color, 1.0f);
                GLAdapter.gl.vertexAttribPointer(s.aPos, 2, 5122, false, 0, ll.vertexOffset);
                GLAdapter.gl.drawElements(1, ll.numIndices, 5123, ll.indiceOffset);
                l = (RenderBucket)l.next;
            }
            return l;
        }

        public static class Shader
        extends GLShader {
            int uMVP;
            int uColor;
            int uWidth;
            int uScreen;
            int aPos;

            Shader(String shaderFile) {
                if (!this.create(shaderFile)) {
                    return;
                }
                this.uMVP = this.getUniform("u_mvp");
                this.uColor = this.getUniform("u_color");
                this.uWidth = this.getUniform("u_width");
                this.uScreen = this.getUniform("u_screen");
                this.aPos = this.getAttrib("a_pos");
            }

            public void set(GLViewport v) {
                this.useProgram();
                GLState.enableVertexArrays(this.aPos, -1);
                v.mvp.setAsUniform(this.uMVP);
                GLAdapter.gl.uniform2f(this.uScreen, v.getWidth() / 2.0f, v.getHeight() / 2.0f);
                GLAdapter.gl.uniform1f(this.uWidth, 1.5f);
                GLAdapter.gl.lineWidth(2.0f);
            }
        }
    }
}

