/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import java.io.IOException;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileInfo;
import org.oscim.tiling.source.mapfile.header.MapFileInfoBuilder;
import org.oscim.tiling.source.mapfile.header.OptionalFields;
import org.oscim.tiling.source.mapfile.header.RequiredFields;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;
import org.oscim.tiling.source.mapfile.header.SubFileParameterBuilder;

public class MapFileHeader {
    private static final int BASE_ZOOM_LEVEL_MAX = 20;
    private static final int HEADER_SIZE_MIN = 70;
    private static final byte SIGNATURE_LENGTH_INDEX = 16;
    private static final char SPACE = ' ';
    private MapFileInfo mapFileInfo;
    private SubFileParameter[] subFileParameters;
    private byte zoomLevelMaximum;
    private byte zoomLevelMinimum;

    public MapFileInfo getMapFileInfo() {
        return this.mapFileInfo;
    }

    public byte getQueryZoomLevel(byte zoomLevel) {
        if (zoomLevel > this.zoomLevelMaximum) {
            return this.zoomLevelMaximum;
        }
        if (zoomLevel < this.zoomLevelMinimum) {
            return this.zoomLevelMinimum;
        }
        return zoomLevel;
    }

    public SubFileParameter getSubFileParameter(int queryZoomLevel) {
        return this.subFileParameters[queryZoomLevel];
    }

    public TileSource.OpenResult readHeader(ReadBuffer readBuffer, long fileSize) throws IOException {
        TileSource.OpenResult openResult = RequiredFields.readMagicByte(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readRemainingHeader(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        MapFileInfoBuilder mapFileInfoBuilder = new MapFileInfoBuilder();
        openResult = RequiredFields.readFileVersion(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readFileSize(readBuffer, fileSize, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readMapDate(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readBoundingBox(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readTilePixelSize(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readProjectionName(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = OptionalFields.readOptionalFields(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readPoiTags(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readWayTags(readBuffer, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = this.readSubFileParameters(readBuffer, fileSize, mapFileInfoBuilder);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        this.mapFileInfo = mapFileInfoBuilder.build();
        return TileSource.OpenResult.SUCCESS;
    }

    private TileSource.OpenResult readSubFileParameters(ReadBuffer readBuffer, long fileSize, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfSubFiles = readBuffer.readByte();
        if (numberOfSubFiles < 1) {
            return new TileSource.OpenResult("invalid number of sub-files: " + numberOfSubFiles);
        }
        mapFileInfoBuilder.numberOfSubFiles = numberOfSubFiles;
        SubFileParameter[] tempSubFileParameters = new SubFileParameter[numberOfSubFiles];
        this.zoomLevelMinimum = (byte)127;
        this.zoomLevelMaximum = (byte)-128;
        for (int currentSubFile = 0; currentSubFile < numberOfSubFiles; currentSubFile = (int)((byte)(currentSubFile + 1))) {
            SubFileParameterBuilder subFileParameterBuilder = new SubFileParameterBuilder();
            byte baseZoomLevel = readBuffer.readByte();
            if (baseZoomLevel < 0 || baseZoomLevel > 20) {
                return new TileSource.OpenResult("invalid base zooom level: " + baseZoomLevel);
            }
            subFileParameterBuilder.baseZoomLevel = baseZoomLevel;
            byte zoomLevelMin = readBuffer.readByte();
            if (zoomLevelMin < 0 || zoomLevelMin > 22) {
                return new TileSource.OpenResult("invalid minimum zoom level: " + zoomLevelMin);
            }
            subFileParameterBuilder.zoomLevelMin = zoomLevelMin;
            byte zoomLevelMax = readBuffer.readByte();
            if (zoomLevelMax < 0 || zoomLevelMax > 22) {
                return new TileSource.OpenResult("invalid maximum zoom level: " + zoomLevelMax);
            }
            subFileParameterBuilder.zoomLevelMax = zoomLevelMax;
            if (zoomLevelMin > zoomLevelMax) {
                return new TileSource.OpenResult("invalid zoom level range: " + zoomLevelMin + ' ' + zoomLevelMax);
            }
            long startAddress = readBuffer.readLong();
            if (startAddress < 70L || startAddress >= fileSize) {
                return new TileSource.OpenResult("invalid start address: " + startAddress);
            }
            subFileParameterBuilder.startAddress = startAddress;
            long indexStartAddress = startAddress;
            if (mapFileInfoBuilder.optionalFields.isDebugFile) {
                indexStartAddress += 16L;
            }
            subFileParameterBuilder.indexStartAddress = indexStartAddress;
            long subFileSize = readBuffer.readLong();
            if (subFileSize < 1L) {
                return new TileSource.OpenResult("invalid sub-file size: " + subFileSize);
            }
            subFileParameterBuilder.subFileSize = subFileSize;
            subFileParameterBuilder.boundingBox = mapFileInfoBuilder.boundingBox;
            tempSubFileParameters[currentSubFile] = subFileParameterBuilder.build();
            this.updateZoomLevelInformation(tempSubFileParameters[currentSubFile]);
        }
        mapFileInfoBuilder.zoomLevel = new int[numberOfSubFiles];
        this.subFileParameters = new SubFileParameter[this.zoomLevelMaximum + 1];
        for (int currentMapFile = 0; currentMapFile < numberOfSubFiles; ++currentMapFile) {
            SubFileParameter subFileParameter = tempSubFileParameters[currentMapFile];
            mapFileInfoBuilder.zoomLevel[currentMapFile] = subFileParameter.baseZoomLevel;
            for (byte zoomLevel = subFileParameter.zoomLevelMin; zoomLevel <= subFileParameter.zoomLevelMax; zoomLevel = (byte)(zoomLevel + 1)) {
                this.subFileParameters[zoomLevel] = subFileParameter;
            }
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private void updateZoomLevelInformation(SubFileParameter subFileParameter) {
        if (this.zoomLevelMinimum > subFileParameter.zoomLevelMin) {
            this.zoomLevelMinimum = subFileParameter.zoomLevelMin;
        }
        if (this.zoomLevelMaximum < subFileParameter.zoomLevelMax) {
            this.zoomLevelMaximum = subFileParameter.zoomLevelMax;
        }
    }
}

