/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.event.Event;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.AbstractMapEventLayer;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.utils.FastMath;

public class MapEventLayer
extends AbstractMapEventLayer
implements Map.InputListener,
GestureListener {
    private boolean mEnableRotate = true;
    private boolean mEnableTilt = true;
    private boolean mEnableMove = true;
    private boolean mEnableScale = true;
    private boolean mFixOnCenter = false;
    private boolean mCanScale;
    private boolean mCanRotate;
    private boolean mCanTilt;
    private boolean mDoRotate;
    private boolean mDoScale;
    private boolean mDoTilt;
    private boolean mDown;
    private boolean mDoubleTap;
    private boolean mDragZoom;
    private float mPrevX1;
    private float mPrevY1;
    private float mPrevX2;
    private float mPrevY2;
    private double mAngle;
    private double mPrevPinchWidth;
    private long mStartMove;
    private static final float MIN_SLOP = 12.7f;
    private static final float PINCH_ZOOM_THRESHOLD = 6.35f;
    private static final float PINCH_TILT_THRESHOLD = 6.35f;
    private static final float PINCH_TILT_SLOPE = 0.75f;
    private static final float PINCH_ROTATE_THRESHOLD = 0.2f;
    private static final float PINCH_ROTATE_THRESHOLD2 = 0.5f;
    private static final float FLING_MIN_THREHSHOLD = 100.0f;
    private final VelocityTracker mTracker;
    private final MapPosition mapPosition = new MapPosition();

    public MapEventLayer(Map map) {
        super(map);
        this.mTracker = new VelocityTracker();
    }

    @Override
    public void onInputEvent(Event e, MotionEvent motionEvent) {
        this.onTouchEvent(motionEvent);
    }

    @Override
    public void enableRotation(boolean enable) {
        this.mEnableRotate = enable;
    }

    @Override
    public boolean rotationEnabled() {
        return this.mEnableRotate;
    }

    @Override
    public void enableTilt(boolean enable) {
        this.mEnableTilt = enable;
    }

    @Override
    public boolean tiltEnabled() {
        return this.mEnableTilt;
    }

    @Override
    public void enableMove(boolean enable) {
        this.mEnableMove = enable;
    }

    @Override
    public boolean moveEnabled() {
        return this.mEnableMove;
    }

    @Override
    public void enableZoom(boolean enable) {
        this.mEnableScale = enable;
    }

    @Override
    public boolean zoomEnabled() {
        return this.mEnableScale;
    }

    @Override
    public void setFixOnCenter(boolean enable) {
        this.mFixOnCenter = enable;
    }

    boolean onTouchEvent(MotionEvent e) {
        int action = MapEventLayer.getAction(e);
        if (action == 0) {
            this.mMap.animator().cancel();
            this.mStartMove = -1L;
            this.mDoubleTap = false;
            this.mDragZoom = false;
            this.mPrevX1 = e.getX(0);
            this.mPrevY1 = e.getY(0);
            this.mDown = true;
            return true;
        }
        if (!this.mDown && !this.mDoubleTap) {
            return false;
        }
        if (action == 2) {
            this.onActionMove(e);
            return true;
        }
        if (action == 1) {
            this.mDown = false;
            if (this.mDoubleTap && !this.mDragZoom) {
                float pivotX = 0.0f;
                float pivotY = 0.0f;
                if (!this.mFixOnCenter) {
                    pivotX = this.mPrevX1 - (float)(this.mMap.getWidth() / 2);
                    pivotY = this.mPrevY1 - (float)(this.mMap.getHeight() / 2);
                }
                this.mMap.animator().animateZoom(300L, 2.0, pivotX, pivotY);
            } else if (this.mStartMove > 0L) {
                this.mTracker.update(e.getX(), e.getY(), e.getTime());
                float vx = this.mTracker.getVelocityX();
                float vy = this.mTracker.getVelocityY();
                float t = e.getTime() - this.mStartMove;
                if (t < 100.0f) {
                    vy *= (t /= 100.0f) * t;
                    vx *= t * t;
                }
                this.doFling(vx, vy);
            }
            return true;
        }
        if (action == 3) {
            return false;
        }
        if (action == 5) {
            this.mStartMove = -1L;
            this.updateMulti(e);
            return true;
        }
        if (action == 6) {
            this.updateMulti(e);
            return true;
        }
        return false;
    }

    private static int getAction(MotionEvent e) {
        return e.getAction() & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onActionMove(MotionEvent e) {
        double r;
        double rad;
        ViewController mViewport = this.mMap.viewport();
        float x1 = e.getX(0);
        float y1 = e.getY(0);
        float mx = x1 - this.mPrevX1;
        float my = y1 - this.mPrevY1;
        float width = this.mMap.getWidth();
        float height = this.mMap.getHeight();
        if (e.getPointerCount() < 2) {
            this.mPrevX1 = x1;
            this.mPrevY1 = y1;
            if (this.mDoubleTap) {
                if (!this.mDown) {
                    this.mDown = true;
                    return;
                }
                if (!this.mDragZoom && !this.isMinimalMove(mx, my)) {
                    this.mPrevX1 -= mx;
                    this.mPrevY1 -= my;
                    return;
                }
                this.mDragZoom = true;
                mViewport.scaleMap(1.0f + my / (height / 6.0f), 0.0f, 0.0f);
                this.mMap.updateMap(true);
                this.mStartMove = -1L;
                return;
            }
            if (!this.mEnableMove) {
                return;
            }
            if (this.mStartMove < 0L) {
                if (!this.isMinimalMove(mx, my)) {
                    this.mPrevX1 -= mx;
                    this.mPrevY1 -= my;
                    return;
                }
                this.mStartMove = e.getTime();
                this.mTracker.start(x1, y1, this.mStartMove);
                return;
            }
            mViewport.moveMap(mx, my);
            this.mTracker.update(x1, y1, e.getTime());
            this.mMap.updateMap(true);
            if (this.mMap.viewport().getMapPosition(this.mapPosition)) {
                this.mMap.events.fire(Map.MOVE_EVENT, this.mapPosition);
            }
            return;
        }
        this.mStartMove = -1L;
        float x2 = e.getX(1);
        float y2 = e.getY(1);
        float dx = x1 - x2;
        float dy = y1 - y2;
        double rotateBy = 0.0;
        float scaleBy = 1.0f;
        float tiltBy = 0.0f;
        mx = (x1 + x2 - (this.mPrevX1 + this.mPrevX2)) / 2.0f;
        my = (y1 + y2 - (this.mPrevY1 + this.mPrevY2)) / 2.0f;
        if (this.mCanTilt) {
            float slope;
            float f = slope = dx == 0.0f ? 0.0f : dy / dx;
            if (Math.abs(slope) < 0.75f) {
                if (this.mDoTilt) {
                    tiltBy = my / 5.0f;
                } else if (Math.abs(my) > CanvasAdapter.dpi / 6.35f) {
                    this.mCanScale = false;
                    this.mCanRotate = false;
                    this.mDoTilt = true;
                }
            }
        }
        double pinchWidth = Math.sqrt(dx * dx + dy * dy);
        double deltaPinch = pinchWidth - this.mPrevPinchWidth;
        if (this.mCanRotate) {
            rad = Math.atan2(dy, dx);
            r = rad - this.mAngle;
            if (this.mDoRotate) {
                double da = rad - this.mAngle;
                if (Math.abs(da) > 1.0E-4) {
                    rotateBy = da;
                    this.mAngle = rad;
                    deltaPinch = 0.0;
                }
            } else if ((r = Math.abs(r)) > (double)0.2f) {
                this.mDoRotate = true;
                this.mCanTilt = false;
                this.mAngle = rad;
            } else if (!this.mDoScale) {
                deltaPinch *= 1.0 - r / (double)0.2f;
            } else {
                this.mPrevPinchWidth = pinchWidth;
            }
        } else if (this.mDoScale && this.mEnableRotate && (r = (rad = Math.atan2(dy, dx)) - this.mAngle) > 0.5) {
            this.mDoRotate = true;
            this.mCanRotate = true;
            this.mAngle = rad;
        }
        if (this.mCanScale || this.mDoRotate) {
            if (!this.mDoScale && !this.mDoRotate && Math.abs(deltaPinch) > (double)(CanvasAdapter.dpi / 6.35f)) {
                if (!this.mDoRotate) {
                    this.mPrevPinchWidth = pinchWidth;
                    this.mCanRotate = false;
                }
                this.mCanTilt = false;
                this.mDoScale = true;
            }
            if (this.mDoScale || this.mDoRotate) {
                scaleBy = (float)(pinchWidth / this.mPrevPinchWidth);
                this.mPrevPinchWidth = pinchWidth;
            }
        }
        if (!(this.mDoRotate || this.mDoScale || this.mDoTilt)) {
            return;
        }
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        if (!this.mFixOnCenter) {
            pivotX = (x2 + x1) / 2.0f - width / 2.0f;
            pivotY = (y2 + y1) / 2.0f - height / 2.0f;
        }
        ViewController viewController = mViewport;
        synchronized (viewController) {
            if (!this.mDoTilt) {
                if (rotateBy != 0.0) {
                    mViewport.rotateMap(rotateBy, pivotX, pivotY);
                }
                if (scaleBy != 1.0f) {
                    mViewport.scaleMap(scaleBy, pivotX, pivotY);
                }
                if (!this.mFixOnCenter) {
                    mViewport.moveMap(mx, my);
                }
            } else if (tiltBy != 0.0f && mViewport.tiltMap(-tiltBy)) {
                mViewport.moveMap(0.0f, my / 2.0f);
            }
        }
        this.mPrevX1 = x1;
        this.mPrevY1 = y1;
        this.mPrevX2 = x2;
        this.mPrevY2 = y2;
        this.mMap.updateMap(true);
        if (this.mMap.viewport().getMapPosition(this.mapPosition)) {
            if (this.mDoScale) {
                this.mMap.events.fire(Map.SCALE_EVENT, this.mapPosition);
            }
            if (this.mDoRotate) {
                this.mMap.events.fire(Map.ROTATE_EVENT, this.mapPosition);
            }
            if (this.mDoTilt) {
                this.mMap.events.fire(Map.TILT_EVENT, this.mapPosition);
            }
        }
    }

    private void updateMulti(MotionEvent e) {
        int cnt = e.getPointerCount();
        this.mPrevX1 = e.getX(0);
        this.mPrevY1 = e.getY(0);
        if (cnt == 2) {
            this.mDoScale = false;
            this.mDoRotate = false;
            this.mDoTilt = false;
            this.mCanScale = this.mEnableScale;
            this.mCanRotate = this.mEnableRotate;
            this.mCanTilt = this.mEnableTilt;
            this.mPrevX2 = e.getX(1);
            this.mPrevY2 = e.getY(1);
            double dx = this.mPrevX1 - this.mPrevX2;
            double dy = this.mPrevY1 - this.mPrevY2;
            this.mAngle = Math.atan2(dy, dx);
            this.mPrevPinchWidth = Math.sqrt(dx * dx + dy * dy);
        }
    }

    private boolean isMinimalMove(float mx, float my) {
        float minSlop = CanvasAdapter.dpi / 12.7f;
        return !FastMath.withinSquaredDist(mx, my, minSlop * minSlop);
    }

    private boolean doFling(float velocityX, float velocityY) {
        int w = Tile.SIZE * 5;
        int h = Tile.SIZE * 5;
        this.mMap.animator().animateFling(velocityX * 2.0f, velocityY * 2.0f, -w, w, -h, h);
        return true;
    }

    @Override
    public boolean onGesture(Gesture g, MotionEvent e) {
        if (g == Gesture.DOUBLE_TAP) {
            this.mDoubleTap = true;
            return true;
        }
        return false;
    }

    private static class VelocityTracker {
        private static final int MAX_MS = 200;
        private static final int SAMPLES = 32;
        private float mLastX;
        private float mLastY;
        private long mLastTime;
        private int mNumSamples;
        private int mIndex;
        private float[] mMeanX = new float[32];
        private float[] mMeanY = new float[32];
        private int[] mMeanTime = new int[32];

        private VelocityTracker() {
        }

        public void start(float x, float y, long time) {
            this.mLastX = x;
            this.mLastY = y;
            this.mNumSamples = 0;
            this.mIndex = 32;
            this.mLastTime = time;
        }

        public void update(float x, float y, long time) {
            if (time == this.mLastTime) {
                return;
            }
            if (--this.mIndex < 0) {
                this.mIndex = 31;
            }
            this.mMeanX[this.mIndex] = x - this.mLastX;
            this.mMeanY[this.mIndex] = y - this.mLastY;
            this.mMeanTime[this.mIndex] = (int)(time - this.mLastTime);
            this.mLastTime = time;
            this.mLastX = x;
            this.mLastY = y;
            ++this.mNumSamples;
        }

        private float getVelocity(float[] move) {
            this.mNumSamples = Math.min(32, this.mNumSamples);
            double duration = 0.0;
            double amount = 0.0;
            for (int c = 0; c < this.mNumSamples; ++c) {
                int index = (this.mIndex + c) % 32;
                float d = this.mMeanTime[index];
                if (c > 0 && duration + (double)d > 200.0) break;
                amount += (double)move[index] * ((double)d / (duration += (double)d));
            }
            if (duration == 0.0) {
                return 0.0f;
            }
            return (float)(amount * 1000.0 / duration);
        }

        float getVelocityY() {
            return this.getVelocity(this.mMeanY);
        }

        float getVelocityX() {
            return this.getVelocity(this.mMeanX);
        }
    }
}

