/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import java.util.ArrayList;
import java.util.Arrays;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.event.Event;
import org.oscim.event.EventDispatcher;
import org.oscim.event.EventListener;
import org.oscim.layers.tile.JobQueue;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileDistanceSort;
import org.oscim.layers.tile.TileSet;
import org.oscim.map.Map;
import org.oscim.map.Viewport;
import org.oscim.renderer.BufferObject;
import org.oscim.tiling.QueryResult;
import org.oscim.utils.FastMath;
import org.oscim.utils.ScanBox;
import org.oscim.utils.quadtree.TileIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileManager {
    static final Logger log = LoggerFactory.getLogger(TileManager.class);
    static final boolean dbg = false;
    public static final Event TILE_LOADED = new Event();
    public static final Event TILE_REMOVED = new Event();
    private final int mCacheLimit;
    private int mCacheReduce;
    private int mMinZoom;
    private int mMaxZoom;
    private int[] mZoomTable;
    private static final int MAX_TILES_IN_QUEUE = 20;
    private static final int CACHE_THRESHOLD = 25;
    private static final int CACHE_CLEAR_THRESHOLD = 10;
    private final Map mMap;
    private final Viewport mViewport;
    private MapTile[] mTiles;
    private int mTilesCount;
    private int mTilesEnd;
    private int mTilesToUpload;
    private final ArrayList<MapTile> mJobs;
    private int mUpdateSerial;
    private final Object mTilelock = new Object();
    private TileSet mCurrentTiles;
    TileSet mNewTiles;
    private final JobQueue jobQueue;
    private final float[] mMapPlane = new float[8];
    private boolean mLoadParent;
    private int mPrevZoomlevel;
    private double mLevelUpThreshold = 1.0;
    private double mLevelDownThreshold = 2.0;
    private final TileIndex<MapTile.TileNode, MapTile> mIndex = new TileIndex<MapTile.TileNode, MapTile>(){

        @Override
        public void removeItem(MapTile t) {
            if (t.node == null) {
                throw new IllegalStateException("Already removed: " + t);
            }
            super.remove(t.node);
            t.node.item = null;
        }

        @Override
        public MapTile.TileNode create() {
            return new MapTile.TileNode();
        }
    };
    public final EventDispatcher<Listener, MapTile> events = new EventDispatcher<Listener, MapTile>(){

        @Override
        public void tell(Listener l, Event event, MapTile tile) {
            l.onTileManagerEvent(event, tile);
        }
    };
    private final ScanBox mScanBox = new ScanBox(){

        @Override
        protected void setVisible(int y, int x1, int x2) {
            MapTile[] tiles = TileManager.this.mNewTiles.tiles;
            int cnt = TileManager.this.mNewTiles.cnt;
            int maxTiles = tiles.length;
            int xmax = 1 << this.mZoom;
            for (int x = x1; x < x2; ++x) {
                MapTile tile = null;
                if (cnt == maxTiles) {
                    log.debug("too many tiles {}", (Object)maxTiles);
                    break;
                }
                int xx = x;
                if (!(x >= 0 && x < xmax || (xx = x < 0 ? xmax + x : x - xmax) >= 0 && xx < xmax)) continue;
                for (int i = 0; i < cnt; ++i) {
                    if (tiles[i].tileX != xx || tiles[i].tileY != y) continue;
                    tile = tiles[i];
                    break;
                }
                if (tile != null) continue;
                tile = TileManager.this.addTile(xx, y, this.mZoom);
                tiles[cnt++] = tile;
            }
            TileManager.this.mNewTiles.cnt = cnt;
        }
    };

    public TileManager(Map map, int cacheLimit) {
        this.mMap = map;
        this.mMaxZoom = 20;
        this.mMinZoom = 0;
        this.mCacheLimit = cacheLimit;
        this.mCacheReduce = 0;
        this.mViewport = map.viewport();
        this.jobQueue = new JobQueue();
        this.mJobs = new ArrayList();
        this.mTiles = new MapTile[this.mCacheLimit];
        this.mTilesEnd = 0;
        this.mTilesToUpload = 0;
        this.mUpdateSerial = 0;
    }

    public void setZoomTable(int[] zoomTable) {
        this.mZoomTable = zoomTable;
    }

    public void setZoomThresholds(float down, float up) {
        this.mLevelDownThreshold = FastMath.clamp(down, 1.0f, 2.0f);
        this.mLevelUpThreshold = FastMath.clamp(up, 1.0f, 2.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapTile getTile(int x, int y, int z) {
        Object object = this.mTilelock;
        synchronized (object) {
            return this.mIndex.getTile(x, y, z);
        }
    }

    public void init() {
        if (this.mCurrentTiles != null) {
            this.mCurrentTiles.releaseTiles();
        }
        this.mIndex.drop();
        for (int i = 0; i < this.mTilesEnd; ++i) {
            MapTile t = this.mTiles[i];
            if (t == null) continue;
            if (!t.isLocked()) {
                t.clear();
            }
            t.setState((byte)64);
        }
        Arrays.fill(this.mTiles, null);
        this.mTilesEnd = 0;
        this.mTilesCount = 0;
        int num = Math.max(this.mMap.getWidth(), this.mMap.getHeight());
        int size = Tile.SIZE >> 1;
        int numTiles = num * num / (size * size) * 4;
        this.mNewTiles = new TileSet(numTiles);
        this.mCurrentTiles = new TileSet(numTiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(MapPosition pos) {
        int remove;
        if (this.mNewTiles == null || this.mNewTiles.tiles.length == 0) {
            this.mPrevZoomlevel = pos.zoomLevel;
            this.init();
        }
        this.jobQueue.clear();
        if (pos.zoomLevel < this.mMinZoom) {
            if (this.mCurrentTiles.cnt > 0 && pos.zoomLevel < this.mMinZoom - 4) {
                Object object = this.mTilelock;
                synchronized (object) {
                    this.mCurrentTiles.releaseTiles();
                }
            }
            return false;
        }
        int tileZoom = FastMath.clamp(pos.zoomLevel, this.mMinZoom, this.mMaxZoom);
        if (this.mZoomTable == null) {
            double scaleDiv = pos.scale / (double)(1 << tileZoom);
            this.mLoadParent = scaleDiv < 1.5;
            int zoomDiff = tileZoom - this.mPrevZoomlevel;
            if (zoomDiff == 1) {
                if (scaleDiv < this.mLevelUpThreshold) {
                    tileZoom = this.mPrevZoomlevel;
                    this.mLoadParent = false;
                }
            } else if (zoomDiff == -1 && scaleDiv > this.mLevelDownThreshold) {
                tileZoom = this.mPrevZoomlevel;
                this.mLoadParent = true;
            }
        } else {
            this.mLoadParent = false;
            int match = 0;
            for (int z : this.mZoomTable) {
                if (z > tileZoom || z <= match) continue;
                match = z;
            }
            if (match == 0) {
                return false;
            }
            tileZoom = match;
        }
        this.mPrevZoomlevel = tileZoom;
        this.mViewport.getMapExtents(this.mMapPlane, Tile.SIZE / 2);
        this.mNewTiles.cnt = 0;
        this.mScanBox.scan(pos.x, pos.y, pos.scale, tileZoom, this.mMapPlane);
        MapTile[] newTiles = this.mNewTiles.tiles;
        int newCnt = this.mNewTiles.cnt;
        MapTile[] curTiles = this.mCurrentTiles.tiles;
        int curCnt = this.mCurrentTiles.cnt;
        boolean changed = newCnt != curCnt;
        Arrays.sort(newTiles, 0, newCnt, TileSet.coordComparator);
        if (!changed) {
            for (int i = 0; i < newCnt; ++i) {
                if (newTiles[i] == curTiles[i]) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            Object i = this.mTilelock;
            synchronized (i) {
                this.mNewTiles.lockTiles();
                this.mCurrentTiles.releaseTiles();
                TileSet tmp = this.mCurrentTiles;
                this.mCurrentTiles = this.mNewTiles;
                this.mNewTiles = tmp;
                ++this.mUpdateSerial;
            }
            this.mMap.render();
        }
        if (this.mJobs.isEmpty()) {
            return false;
        }
        MapTile[] jobs = new MapTile[this.mJobs.size()];
        jobs = this.mJobs.toArray(jobs);
        TileManager.updateDistances(jobs, jobs.length, pos);
        this.jobQueue.setJobs(jobs);
        this.mJobs.clear();
        if (this.mCacheReduce < this.mCacheLimit / 2) {
            this.mCacheReduce = BufferObject.isMaxFill() ? (this.mCacheReduce += 10) : 0;
        }
        if ((remove = this.mTilesCount - (this.mCacheLimit - this.mCacheReduce)) > 25 || this.mTilesToUpload > 20) {
            Object object = this.mTilelock;
            synchronized (object) {
                this.limitCache(pos, remove);
            }
        }
        return true;
    }

    public void clearJobs() {
        this.jobQueue.clear();
    }

    public boolean hasTileJobs() {
        return !this.jobQueue.isEmpty();
    }

    public MapTile getTileJob() {
        return this.jobQueue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getActiveTiles(TileSet tileSet) {
        if (this.mCurrentTiles == null) {
            return false;
        }
        if (tileSet == null) {
            return false;
        }
        if (tileSet.serial == this.mUpdateSerial) {
            return false;
        }
        Object object = this.mTilelock;
        synchronized (object) {
            tileSet.setTiles(this.mCurrentTiles);
            tileSet.serial = this.mUpdateSerial;
        }
        return true;
    }

    MapTile addTile(int x, int y, int zoomLevel) {
        MapTile tile = this.mIndex.getTile(x, y, zoomLevel);
        if (tile == null) {
            MapTile.TileNode n = this.mIndex.add(x, y, zoomLevel);
            n.item = new MapTile(n, x, y, zoomLevel);
            tile = n.item;
            tile.setState((byte)2);
            this.mJobs.add(tile);
            this.addToCache(tile);
        } else if (!tile.isActive()) {
            tile.setState((byte)2);
            this.mJobs.add(tile);
        }
        if (this.mLoadParent && zoomLevel > this.mMinZoom && this.mZoomTable == null) {
            MapTile p = (MapTile)tile.node.parent();
            if (p == null) {
                MapTile.TileNode n = this.mIndex.add(x >> 1, y >> 1, zoomLevel - 1);
                n.item = new MapTile(n, x >> 1, y >> 1, zoomLevel - 1);
                p = n.item;
                this.addToCache(p);
                p.setState((byte)2);
                this.mJobs.add(p);
            } else if (!p.isActive()) {
                p.setState((byte)2);
                this.mJobs.add(p);
            }
        }
        return tile;
    }

    private void addToCache(MapTile tile) {
        if (this.mTilesEnd == this.mTiles.length) {
            if (this.mTilesEnd > this.mTilesCount) {
                TileDistanceSort.sort(this.mTiles, 0, this.mTilesEnd);
                this.mTilesEnd = this.mTilesCount;
            }
            if (this.mTilesEnd == this.mTiles.length) {
                log.debug("realloc tiles {}", (Object)this.mTilesEnd);
                MapTile[] tmp = new MapTile[this.mTiles.length + 20];
                System.arraycopy(this.mTiles, 0, tmp, 0, this.mTilesCount);
                this.mTiles = tmp;
            }
        }
        this.mTiles[this.mTilesEnd++] = tile;
        ++this.mTilesCount;
    }

    private boolean removeFromCache(MapTile t) {
        if (t.isLocked()) {
            return false;
        }
        if (t.state(12)) {
            this.events.fire(TILE_REMOVED, t);
        }
        t.clear();
        this.mIndex.removeItem(t);
        --this.mTilesCount;
        return true;
    }

    private void limitCache(MapPosition pos, int remove) {
        MapTile t;
        int i;
        MapTile[] tiles = this.mTiles;
        int newTileCnt = 0;
        for (i = 0; i < this.mTilesEnd; ++i) {
            t = tiles[i];
            if (t == null) continue;
            if (t.state(4)) {
                ++newTileCnt;
            }
            if (t.state(64)) {
                log.debug("found DEADBEEF {}", (Object)t);
                t.clear();
                tiles[i] = null;
                continue;
            }
            if (!t.state(1) || !this.removeFromCache(t)) continue;
            tiles[i] = null;
            --remove;
        }
        if (remove < 10 && newTileCnt < 20) {
            return;
        }
        TileManager.updateDistances(tiles, this.mTilesEnd, pos);
        TileDistanceSort.sort(tiles, 0, this.mTilesEnd);
        this.mTilesEnd = this.mTilesCount;
        for (i = this.mTilesCount - 1; i >= 0 && remove > 0; --i) {
            t = tiles[i];
            if (t.isLocked() || t.state(16)) continue;
            if (t.state(2)) {
                t.setState((byte)16);
                continue;
            }
            if (t.state(4)) {
                --newTileCnt;
            }
            if (!t.state(12)) {
                log.error("stuff that should be here! {} {}", (Object)t, (Object)t.state());
            }
            if (!this.removeFromCache(t)) continue;
            tiles[i] = null;
            --remove;
        }
        for (i = this.mTilesCount - 1; i >= 0 && newTileCnt > 20; --i) {
            t = tiles[i];
            if (t == null || !t.state(4) || !this.removeFromCache(t)) continue;
            tiles[i] = null;
            --newTileCnt;
        }
        this.mTilesToUpload = newTileCnt;
    }

    public void jobCompleted(MapTile tile, QueryResult result) {
        this.mMap.post(new JobCompletedEvent(tile, result));
        if (tile.isLocked()) {
            if (result == QueryResult.DELAYED && tile.isLocked()) {
                this.mMap.updateMap(false);
            } else {
                this.mMap.render();
            }
        }
    }

    private static void updateDistances(MapTile[] tiles, int size, MapPosition pos) {
        int zoom = 20;
        long x = (long)(pos.x * (double)(1 << zoom));
        long y = (long)(pos.y * (double)(1 << zoom));
        for (int i = 0; i < size; ++i) {
            long dy;
            long dx;
            MapTile t = tiles[i];
            if (t == null) continue;
            int diff = zoom - t.zoomLevel;
            if (diff == 0) {
                dx = (long)t.tileX - x;
                dy = (long)t.tileY - y;
            } else {
                long mx = x >> diff;
                long my = y >> diff;
                dx = (long)t.tileX - mx;
                dy = (long)t.tileY - my;
            }
            int dz = pos.zoomLevel - t.zoomLevel;
            if (dz == 0) {
                dz = 1;
            } else if (dz < -1) {
                dz = (int)((double)dz * 0.75);
            }
            t.distance = (dx * dx + dy * dy) * (long)(dz * dz);
        }
    }

    public MapTile getTile(int tileX, int tileY, byte zoomLevel) {
        return this.mIndex.getTile(tileX, tileY, zoomLevel);
    }

    public void setZoomLevel(int zoomLevelMin, int zoomLevelMax) {
        this.mMinZoom = zoomLevelMin;
        this.mMaxZoom = zoomLevelMax;
    }

    class JobCompletedEvent
    implements Runnable {
        final MapTile tile;
        final QueryResult result;

        public JobCompletedEvent(MapTile tile, QueryResult result) {
            this.tile = tile;
            this.result = result;
        }

        @Override
        public void run() {
            if (this.result == QueryResult.SUCCESS && this.tile.state(2)) {
                this.tile.setState((byte)4);
                TileManager.this.events.fire(TILE_LOADED, this.tile);
                TileManager.this.mTilesToUpload++;
                return;
            }
            log.debug("Load: {} {} state:{}", new Object[]{this.tile, this.result, this.tile.state()});
            if (this.tile.state(64)) {
                this.tile.clear();
                return;
            }
            this.tile.clear();
        }
    }

    public static interface Listener
    extends EventListener {
        public void onTileManagerEvent(Event var1, MapTile var2);
    }
}

