/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import java.util.Arrays;
import java.util.Comparator;
import org.oscim.layers.tile.MapTile;

public final class TileSet {
    public int cnt = 0;
    public MapTile[] tiles;
    int serial;
    public static Comparator<MapTile> coordComparator = new CoordComparator();

    public TileSet() {
        this.tiles = new MapTile[1];
    }

    public TileSet(int numTiles) {
        this.tiles = new MapTile[numTiles];
    }

    public MapTile getTile(int x, int y) {
        for (int i = 0; i < this.cnt; ++i) {
            if (this.tiles[i].tileX != x || this.tiles[i].tileY != y) continue;
            return this.tiles[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTiles() {
        Class<TileSet> clazz = TileSet.class;
        synchronized (TileSet.class) {
            for (int i = 0; i < this.cnt; ++i) {
                this.tiles[i].lock();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTiles() {
        Class<TileSet> clazz = TileSet.class;
        synchronized (TileSet.class) {
            for (int i = 0; i < this.cnt; ++i) {
                this.tiles[i].unlock();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Arrays.fill(this.tiles, null);
            this.cnt = 0;
            this.serial = 0;
            return;
        }
    }

    public void setTiles(TileSet source) {
        source.lockTiles();
        this.releaseTiles();
        if (source.tiles.length != this.tiles.length) {
            this.tiles = new MapTile[source.tiles.length];
        }
        System.arraycopy(source.tiles, 0, this.tiles, 0, source.cnt);
        this.cnt = source.cnt;
    }

    public boolean contains(MapTile t) {
        for (int i = 0; i < this.cnt; ++i) {
            if (!this.tiles[i].equals(t)) continue;
            return true;
        }
        return false;
    }

    public static class CoordComparator
    implements Comparator<MapTile> {
        @Override
        public int compare(MapTile lhs, MapTile rhs) {
            if (lhs.tileX == rhs.tileX) {
                if (lhs.tileY == rhs.tileY) {
                    return 0;
                }
                if (lhs.tileY < rhs.tileY) {
                    return 1;
                }
                return -1;
            }
            if (lhs.tileX < rhs.tileX) {
                return 1;
            }
            return -1;
        }
    }
}

