/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.core.MapPosition;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.map.Viewport;
import org.oscim.renderer.GLMatrix;
import org.oscim.utils.FastMath;
import org.oscim.utils.ThreadUtils;

public class ViewController
extends Viewport {
    protected float mPivotY = 0.0f;
    private final float[] mat = new float[16];
    public final Viewport mNextFrame = new Viewport();

    public void setScreenSize(int width, int height) {
        ThreadUtils.assertMainThread();
        this.mHeight = height;
        this.mWidth = width;
        float ratio = this.mHeight / this.mWidth * 0.16666667f;
        GLMatrix.frustumM(this.mat, 0, -0.16666667f, 0.16666667f, ratio, -ratio, 1.0f, 8.0f);
        this.mProjMatrix.set(this.mat);
        this.mTmpMatrix.setTranslation(0.0f, 0.0f, -3.0f);
        this.mProjMatrix.multiplyRhs(this.mTmpMatrix);
        this.mProjMatrix.get(this.mat);
        GLMatrix.invertM(this.mat, 0, this.mat, 0);
        this.mProjMatrixInverse.set(this.mat);
        this.mProjMatrixUnscaled.copy(this.mProjMatrix);
        this.mTmpMatrix.setScale(1.0f / this.mWidth, 1.0f / this.mWidth, 1.0f / this.mWidth);
        this.mProjMatrix.multiplyRhs(this.mTmpMatrix);
        this.updateMatrices();
    }

    public void setMapScreenCenter(float pivotY) {
        this.mPivotY = FastMath.clamp(pivotY, -1.0f, 1.0f) * 0.5f;
    }

    public void moveMap(float mx, float my) {
        ThreadUtils.assertMainThread();
        Point p = this.applyRotation(mx, my);
        double tileScale = this.mPos.scale * (double)Tile.SIZE;
        this.moveTo(this.mPos.x - p.x / tileScale, this.mPos.y - p.y / tileScale);
    }

    void moveTo(double x, double y) {
        this.mPos.x = x;
        this.mPos.y = y;
        this.mPos.y = FastMath.clamp(this.mPos.y, 0.0, 1.0);
        while (this.mPos.x > 1.0) {
            this.mPos.x -= 1.0;
        }
        while (this.mPos.x < 0.0) {
            this.mPos.x += 1.0;
        }
        if (this.mPos.x > this.mMaxX) {
            this.mPos.x = this.mMaxX;
        } else if (this.mPos.x < this.mMinX) {
            this.mPos.x = this.mMinX;
        }
        if (this.mPos.y > this.mMaxY) {
            this.mPos.y = this.mMaxY;
        } else if (this.mPos.y < this.mMinY) {
            this.mPos.y = this.mMinY;
        }
    }

    private Point applyRotation(double mx, double my) {
        if (this.mPos.bearing == 0.0f) {
            this.mMovePoint.x = mx;
            this.mMovePoint.y = my;
        } else {
            double rad = Math.toRadians(this.mPos.bearing);
            double rcos = Math.cos(rad);
            double rsin = Math.sin(rad);
            this.mMovePoint.x = mx * rcos + my * rsin;
            this.mMovePoint.y = mx * -rsin + my * rcos;
        }
        return this.mMovePoint;
    }

    public boolean scaleMap(float scale, float pivotX, float pivotY) {
        ThreadUtils.assertMainThread();
        if ((double)scale < 1.0E-6) {
            return false;
        }
        double newScale = this.mPos.scale * (double)scale;
        if ((newScale = FastMath.clamp(newScale, this.mMinScale, this.mMaxScale)) == this.mPos.scale) {
            return false;
        }
        scale = (float)(newScale / this.mPos.scale);
        this.mPos.scale = newScale;
        if (pivotX != 0.0f || pivotY != 0.0f) {
            this.moveMap(pivotX * (1.0f - scale), (pivotY -= this.mHeight * this.mPivotY) * (1.0f - scale));
        }
        return true;
    }

    public void rotateMap(double radians, float pivotX, float pivotY) {
        ThreadUtils.assertMainThread();
        double rsin = Math.sin(radians);
        double rcos = Math.cos(radians);
        float x = (float)((double)pivotX - (double)pivotX * rcos + (double)(pivotY -= this.mHeight * this.mPivotY) * rsin);
        float y = (float)((double)pivotY - (double)pivotX * rsin - (double)pivotY * rcos);
        this.moveMap(x, y);
        this.setRotation((double)this.mPos.bearing + Math.toDegrees(radians));
    }

    public void setRotation(double degree) {
        ThreadUtils.assertMainThread();
        while (degree > 180.0) {
            degree -= 360.0;
        }
        while (degree < -180.0) {
            degree += 360.0;
        }
        this.mPos.bearing = (float)degree;
        this.updateMatrices();
    }

    public boolean tiltMap(float move) {
        return this.setTilt(this.mPos.tilt + move);
    }

    public boolean setTilt(float tilt) {
        ThreadUtils.assertMainThread();
        tilt = this.limitTilt(tilt);
        if (tilt == this.mPos.tilt) {
            return false;
        }
        this.mPos.tilt = tilt;
        this.updateMatrices();
        return true;
    }

    public void setMapPosition(MapPosition mapPosition) {
        ThreadUtils.assertMainThread();
        this.mPos.copy(mapPosition);
        this.limitPosition(this.mPos);
        this.updateMatrices();
    }

    private void updateMatrices() {
        this.mRotationMatrix.setRotation(this.mPos.bearing, 0.0f, 0.0f, 1.0f);
        this.mTmpMatrix.setRotation(this.mPos.tilt, 1.0f, 0.0f, 0.0f);
        this.mRotationMatrix.multiplyLhs(this.mTmpMatrix);
        this.mViewMatrix.copy(this.mRotationMatrix);
        this.mTmpMatrix.setTranslation(0.0f, this.mPivotY * this.mHeight, 0.0f);
        this.mViewMatrix.multiplyLhs(this.mTmpMatrix);
        this.mViewProjMatrix.multiplyMM(this.mProjMatrix, this.mViewMatrix);
        this.mViewProjMatrix.get(this.mat);
        GLMatrix.invertM(this.mat, 0, this.mat, 0);
        this.mUnprojMatrix.set(this.mat);
    }

    public final Viewport getSyncViewport() {
        return this.mNextFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sizeChanged() {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            return this.mNextFrame.sizeChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncViewport() {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            this.mNextFrame.copy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSyncViewport(Viewport v) {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            return v.copy(this.mNextFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSyncMapPosition(MapPosition mapPosition) {
        Viewport viewport = this.mNextFrame;
        synchronized (viewport) {
            return this.mNextFrame.getMapPosition(mapPosition);
        }
    }
}

