/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.Buffer;
import javax.annotation.CheckReturnValue;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferObject
extends Inlist<BufferObject> {
    static final Logger log = LoggerFactory.getLogger(BufferObject.class);
    private static final int MB = 0x100000;
    private static final int LIMIT_BUFFERS = 0x1000000;
    private int id;
    private int size;
    private int target;
    private static int mBufferMemoryUsage;
    private static final BufferObject[] pool;
    private static final int[] counter;

    private BufferObject(int target, int id) {
        this.id = id;
        this.target = target;
    }

    public void loadBufferData(Buffer buf, int newSize) {
        boolean clear = false;
        if (buf.position() != 0) {
            log.debug("flip your buffer!");
            buf.flip();
        }
        GLState.bindBuffer(this.target, this.id);
        if (!GLAdapter.NO_BUFFER_SUB_DATA && !clear && this.size > newSize && this.size < newSize * 4) {
            GLAdapter.gl.bufferSubData(this.target, 0, newSize, buf);
        } else {
            mBufferMemoryUsage += newSize - this.size;
            this.size = newSize;
            GLAdapter.gl.bufferData(this.target, this.size, buf, 35044);
        }
    }

    public void bind() {
        GLState.bindBuffer(this.target, this.id);
    }

    public void unbind() {
        GLState.bindBuffer(this.target, 0);
    }

    public static void checkBufferUsage(boolean force) {
        if (mBufferMemoryUsage < 0x1000000) {
            return;
        }
        log.debug("use: " + mBufferMemoryUsage / 0x100000 + "MB");
        log.debug("now: " + (mBufferMemoryUsage -= BufferObject.limitUsage(0x100000)) / 0x100000 + "MB");
    }

    public static synchronized BufferObject get(int target, int size) {
        BufferObject bo;
        int t;
        int n = t = target == 34962 ? 0 : 1;
        if (pool[t] == null) {
            if (counter[t] != 0) {
                throw new IllegalStateException("lost objects: " + counter[t]);
            }
            BufferObject.createBuffers(target, 10);
            int n2 = t;
            counter[n2] = counter[n2] + 10;
        }
        int n3 = t;
        counter[n3] = counter[n3] - 1;
        if (size != 0) {
            bo = pool[t];
            BufferObject min = null;
            BufferObject prev = null;
            while (bo != null) {
                if (bo.size > size && (min == null || ((BufferObject)min.next).size > bo.size)) {
                    min = prev;
                }
                prev = bo;
                bo = (BufferObject)bo.next;
            }
            if (min != null && min != pool[t]) {
                bo = (BufferObject)min.next;
                min.next = bo.next;
                bo.next = null;
                return bo;
            }
        }
        bo = pool[t];
        BufferObject.pool[t] = (BufferObject)BufferObject.pool[t].next;
        bo.next = null;
        return bo;
    }

    @CheckReturnValue
    public static synchronized BufferObject release(BufferObject bo) {
        if (bo == null) {
            return null;
        }
        int t = bo.target == 34962 ? 0 : 1;
        bo.next = pool[t];
        BufferObject.pool[t] = bo;
        int n = t;
        counter[n] = counter[n] + 1;
        return null;
    }

    static synchronized int limitUsage(int reduce) {
        int[] vboIds = new int[10];
        int freed = 0;
        for (int t = 0; t < 2; ++t) {
            int removed = 0;
            BufferObject prev = pool[t];
            if (prev == null) {
                log.debug("nothing to free");
                continue;
            }
            BufferObject bo = (BufferObject)BufferObject.pool[t].next;
            while (bo != null) {
                if (bo.size > 0) {
                    bo.size = 0;
                    vboIds[removed++] = bo.id;
                    prev.next = bo.next;
                    bo = (BufferObject)bo.next;
                    if (removed != 10 && reduce >= (freed += bo.size)) continue;
                    break;
                }
                prev = bo;
                bo = (BufferObject)bo.next;
            }
            if (removed <= 0) continue;
            GLUtils.glDeleteBuffers(removed, vboIds);
            int n = t;
            counter[n] = counter[n] - removed;
        }
        return freed;
    }

    static void createBuffers(int target, int num) {
        int[] mVboIds = GLUtils.glGenBuffers(num);
        int t = target == 34962 ? 0 : 1;
        for (int i = 0; i < num; ++i) {
            BufferObject bo = new BufferObject(target, mVboIds[i]);
            bo.next = pool[t];
            BufferObject.pool[t] = bo;
        }
    }

    static synchronized void clear() {
        mBufferMemoryUsage = 0;
        BufferObject.pool[0] = null;
        BufferObject.pool[1] = null;
        BufferObject.counter[0] = 0;
        BufferObject.counter[1] = 0;
    }

    static synchronized void init(int num) {
        BufferObject.createBuffers(34962, num);
        counter[0] = counter[0] + num;
    }

    public static boolean isMaxFill() {
        return mBufferMemoryUsage > 0x1000000;
    }

    static {
        pool = new BufferObject[2];
        counter = new int[2];
    }
}

