/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.GLAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLState {
    static final Logger log = LoggerFactory.getLogger(GLState.class);
    private static final boolean[] vertexArray = new boolean[]{false, false};
    private static boolean blend = false;
    private static boolean depth = false;
    private static boolean stencil = false;
    private static int shader;
    private static float[] clearColor;
    private static int glVertexBuffer;
    private static int glIndexBuffer;
    private static int currentTexId;

    static void init() {
        GLState.vertexArray[0] = false;
        GLState.vertexArray[1] = false;
        blend = false;
        depth = false;
        stencil = false;
        shader = -1;
        currentTexId = -1;
        glVertexBuffer = -1;
        glIndexBuffer = -1;
        clearColor = null;
        GLAdapter.gl.disable(2960);
        GLAdapter.gl.disable(2929);
        GLAdapter.gl.disable(3042);
    }

    public static boolean useProgram(int shaderProgram) {
        if (shaderProgram < 0) {
            shader = -1;
        } else if (shaderProgram != shader) {
            GLAdapter.gl.useProgram(shaderProgram);
            shader = shaderProgram;
            return true;
        }
        return false;
    }

    public static void blend(boolean enable) {
        if (blend == enable) {
            return;
        }
        if (enable) {
            GLAdapter.gl.enable(3042);
        } else {
            GLAdapter.gl.disable(3042);
        }
        blend = enable;
    }

    public static void testDepth(boolean enable) {
        if (depth != enable) {
            if (enable) {
                GLAdapter.gl.enable(2929);
            } else {
                GLAdapter.gl.disable(2929);
            }
            depth = enable;
        }
    }

    public static void test(boolean depthTest, boolean stencilTest) {
        if (depth != depthTest) {
            if (depthTest) {
                GLAdapter.gl.enable(2929);
            } else {
                GLAdapter.gl.disable(2929);
            }
            depth = depthTest;
        }
        if (stencil != stencilTest) {
            if (stencilTest) {
                GLAdapter.gl.enable(2960);
            } else {
                GLAdapter.gl.disable(2960);
            }
            stencil = stencilTest;
        }
    }

    public static void enableVertexArrays(int va1, int va2) {
        if (va1 > 1 || va2 > 1) {
            log.debug("FIXME: enableVertexArrays...");
        }
        if (va1 == 0 || va2 == 0) {
            if (!vertexArray[0]) {
                GLAdapter.gl.enableVertexAttribArray(0);
                GLState.vertexArray[0] = true;
            }
        } else if (vertexArray[0]) {
            GLAdapter.gl.disableVertexAttribArray(0);
            GLState.vertexArray[0] = false;
        }
        if (va1 == 1 || va2 == 1) {
            if (!vertexArray[1]) {
                GLAdapter.gl.enableVertexAttribArray(1);
                GLState.vertexArray[1] = true;
            }
        } else if (vertexArray[1]) {
            GLAdapter.gl.disableVertexAttribArray(1);
            GLState.vertexArray[1] = false;
        }
    }

    public static void bindTex2D(int id) {
        if (id < 0) {
            GLAdapter.gl.bindTexture(3553, 0);
            currentTexId = 0;
        } else if (currentTexId != id) {
            GLAdapter.gl.bindTexture(3553, id);
            currentTexId = id;
        }
    }

    public static void setClearColor(float[] color) {
        if (!GLAdapter.GDX_DESKTOP_QUIRKS && clearColor != null && color[0] == clearColor[0] && color[1] == clearColor[1] && color[2] == clearColor[2] && color[3] == clearColor[3]) {
            return;
        }
        clearColor = color;
        GLAdapter.gl.clearColor(color[0], color[1], color[2], color[3]);
    }

    public static void bindBuffer(int target, int id) {
        if (target == 34962) {
            if (glVertexBuffer == id) {
                return;
            }
            glVertexBuffer = id;
        } else if (target == 34963) {
            if (glIndexBuffer == id) {
                return;
            }
            glIndexBuffer = id;
        } else {
            log.debug("invalid target {}", (Object)target);
            return;
        }
        if (id >= 0) {
            GLAdapter.gl.bindBuffer(target, id);
        }
    }

    public static void bindElementBuffer(int id) {
        if (glIndexBuffer == id) {
            return;
        }
        glIndexBuffer = id;
        if (id >= 0) {
            GLAdapter.gl.bindBuffer(34963, id);
        }
    }

    public static void bindVertexBuffer(int id) {
        if (glVertexBuffer == id) {
            return;
        }
        glVertexBuffer = id;
        if (id >= 0) {
            GLAdapter.gl.bindBuffer(34962, id);
        }
    }
}

