/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.PointF;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymbolBucket
extends TextureBucket {
    static final Logger log = LoggerFactory.getLogger(SymbolBucket.class);
    private static final float SCALE = 8.0f;
    private static final int VERTICES_PER_SPRITE = 4;
    private static final int LBIT_MASK = -2;
    private TextureItem prevTextures;
    private Inlist.List<SymbolItem> mSymbols = new Inlist.List();

    public SymbolBucket() {
        super(6);
        this.fixed = true;
    }

    public void addSymbol(SymbolItem item) {
        this.numVertices += 4;
        for (SymbolItem it : this.mSymbols) {
            if (it.bitmap != item.bitmap) continue;
            item.next = it.next;
            it.next = item;
            return;
        }
        this.mSymbols.push(item);
    }

    public void pushSymbol(SymbolItem item) {
        this.numVertices += 4;
        this.mSymbols.push(item);
    }

    @Override
    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        this.vertexOffset = vboData.position() * 2;
        int numIndices = 0;
        this.prevTextures = this.textures;
        this.textures = null;
        TextureItem t = null;
        SymbolItem it = this.mSymbols.head();
        while (it != null) {
            int width = 0;
            int height = 0;
            int x = 0;
            int y = 0;
            if (it.texRegion != null) {
                if (this.textures == null) {
                    t = TextureItem.clone(it.texRegion.texture);
                    this.textures = Inlist.appendItem(this.textures, t);
                }
                TextureAtlas.Rect r = it.texRegion.rect;
                x = r.x;
                y = r.y;
                width = r.w;
                height = r.h;
            } else if (it.bitmap != null) {
                t = this.getTexture(it.bitmap);
                if (t == null) {
                    t = new TextureItem(it.bitmap);
                    this.textures = Inlist.appendItem(this.textures, t);
                    t.offset = numIndices;
                    t.indices = 0;
                }
                width = t.width;
                height = t.height;
            } else {
                log.debug("Bad SymbolItem");
                continue;
            }
            short u1 = (short)(8.0f * (float)x);
            short v1 = (short)(8.0f * (float)y);
            short u2 = (short)(8.0f * (float)(x + width));
            short v2 = (short)(8.0f * (float)(y + height));
            PointF prevOffset = null;
            short x1 = 0;
            short y1 = 0;
            short x2 = 0;
            short y2 = 0;
            SymbolItem prev = it;
            while (!(it == null || prev.bitmap != null && prev.bitmap != it.bitmap || prev.texRegion != null && prev.texRegion != it.texRegion)) {
                if (it == prev || it.offset != prevOffset) {
                    prevOffset = it.offset;
                    if (it.offset == null) {
                        float hw = (float)width / 2.0f;
                        float hh = (float)height / 2.0f;
                        x1 = (short)(8.0f * -hw);
                        x2 = (short)(8.0f * hw);
                        y1 = (short)(8.0f * hh);
                        y2 = (short)(8.0f * -hh);
                    } else {
                        float hw = it.offset.x * (float)width;
                        float hh = it.offset.y * (float)height;
                        x1 = (short)(8.0f * -hw);
                        x2 = (short)(8.0f * ((float)width - hw));
                        y1 = (short)(8.0f * ((float)height - hh));
                        y2 = (short)(8.0f * -hh);
                    }
                }
                short tx = (short)((int)(8.0f * it.x) & 0xFFFFFFFE | (it.billboard ? 1 : 0));
                short ty = (short)(8.0f * it.y);
                this.vertexItems.add(tx, ty, x1, y1, u1, v2);
                this.vertexItems.add(tx, ty, x1, y2, u1, v1);
                this.vertexItems.add(tx, ty, x2, y1, u2, v2);
                this.vertexItems.add(tx, ty, x2, y2, u2, v1);
                t.indices += 6;
                it = (SymbolItem)it.next;
            }
            numIndices += t.indices;
        }
        this.vertexItems.compile(vboData);
        for (t = this.prevTextures; t != null; t = t.dispose()) {
        }
        this.prevTextures = null;
    }

    private TextureItem getTexture(Bitmap bitmap) {
        TextureItem t = this.prevTextures;
        while (t != null) {
            if (t.bitmap == bitmap) {
                this.prevTextures = Inlist.remove(this.prevTextures, t);
                this.textures = Inlist.appendItem(this.textures, t);
                t.offset = 0;
                t.indices = 0;
                return t;
            }
            t = (TextureItem)t.next;
        }
        return null;
    }

    public void clearItems() {
        SymbolItem.pool.releaseAll(this.mSymbols.clear());
    }

    @Override
    public void clear() {
        super.clear();
        this.clearItems();
    }
}

