/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.scalebar;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.BitmapRenderer;
import org.oscim.scalebar.MapScaleBar;
import org.oscim.scalebar.MapScaleBarRenderer;

public class MapScaleBarLayer
extends Layer
implements Map.UpdateListener {
    private final MapScaleBar mapScaleBar;
    private final BitmapRenderer bitmapRenderer;

    public MapScaleBarLayer(Map map, MapScaleBar mapScaleBar) {
        super(map);
        this.mapScaleBar = mapScaleBar;
        this.bitmapRenderer = new MapScaleBarRenderer();
        this.mRenderer = this.bitmapRenderer;
        this.bitmapRenderer.setBitmap(mapScaleBar.mapScaleBitmap, mapScaleBar.mapScaleBitmap.getWidth(), mapScaleBar.mapScaleBitmap.getHeight());
    }

    @Override
    public BitmapRenderer getRenderer() {
        return this.bitmapRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMapEvent(Event e, MapPosition mapPosition) {
        if (e == Map.UPDATE_EVENT) {
            return;
        }
        if (!this.mapScaleBar.isVisible()) {
            return;
        }
        if (this.mMap.getHeight() == 0) {
            return;
        }
        if (!this.mapScaleBar.isRedrawNecessary()) {
            return;
        }
        Bitmap bitmap = this.mapScaleBar.mapScaleBitmap;
        synchronized (bitmap) {
            this.mapScaleBar.drawScaleBar();
        }
        this.bitmapRenderer.updateBitmap();
        this.mapScaleBar.redrawNeeded = false;
    }
}

