/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.utils.Utils;

class MatchingCacheKey {
    int mHash;
    Tag[] mTags;

    MatchingCacheKey() {
    }

    MatchingCacheKey(MatchingCacheKey key) {
        this.mTags = key.mTags;
        this.mHash = key.mHash;
    }

    boolean set(TagSet tags, MatchingCacheKey compare) {
        int numTags = tags.numTags;
        if (compare != null && numTags == compare.mTags.length) {
            Tag t2;
            Tag t1;
            int i;
            for (i = 0; i < numTags && ((t1 = tags.tags[i]) == (t2 = compare.mTags[i]) || Utils.equals(t1.key, t2.key) && Utils.equals(t1.value, t2.value)); ++i) {
            }
            if (i == numTags) {
                return true;
            }
        }
        this.mTags = new Tag[numTags];
        int result = 7;
        for (int i = 0; i < numTags; ++i) {
            Tag t = tags.tags[i];
            result = 31 * result + t.hashCode();
            this.mTags[i] = t;
        }
        this.mHash = 31 * result;
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MatchingCacheKey other = (MatchingCacheKey)obj;
        int length = this.mTags.length;
        if (length != other.mTags.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Tag t1 = this.mTags[i];
            Tag t2 = other.mTags[i];
            if (t1 == t2 || Utils.equals(t1.key, t2.key) && Utils.equals(t1.value, t2.value)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mHash;
    }
}

