/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mvt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDecoder
extends PbfDecoder {
    private static final Logger log = LoggerFactory.getLogger(TileDecoder.class);
    private static final int TAG_TILE_LAYERS = 3;
    private static final int TAG_LAYER_VERSION = 15;
    private static final int TAG_LAYER_NAME = 1;
    private static final int TAG_LAYER_FEATURES = 2;
    private static final int TAG_LAYER_KEYS = 3;
    private static final int TAG_LAYER_VALUES = 4;
    private static final int TAG_LAYER_EXTENT = 5;
    private static final int TAG_FEATURE_ID = 1;
    private static final int TAG_FEATURE_TAGS = 2;
    private static final int TAG_FEATURE_TYPE = 3;
    private static final int TAG_FEATURE_GEOMETRY = 4;
    private static final int TAG_VALUE_STRING = 1;
    private static final int TAG_VALUE_FLOAT = 2;
    private static final int TAG_VALUE_DOUBLE = 3;
    private static final int TAG_VALUE_LONG = 4;
    private static final int TAG_VALUE_UINT = 5;
    private static final int TAG_VALUE_SINT = 6;
    private static final int TAG_VALUE_BOOL = 7;
    private static final int TAG_GEOM_UNKNOWN = 0;
    private static final int TAG_GEOM_POINT = 1;
    private static final int TAG_GEOM_LINE = 2;
    private static final int TAG_GEOM_POLYGON = 3;
    private short[] mTmpTags = new short[1024];
    private Tile mTile;
    private final String mLocale;
    private ITileDataSink mMapDataCallback;
    private static final float REF_TILE_SIZE = 4096.0f;
    private float mScale;
    private final Pool<Feature> mFeaturePool = new Pool<Feature>(){
        int count;

        @Override
        protected Feature createItem() {
            ++this.count;
            return new Feature();
        }

        @Override
        protected boolean clearItem(Feature item) {
            if (this.count > 100) {
                --this.count;
                return false;
            }
            item.elem.tags.clear();
            item.elem.clear();
            item.tags = null;
            item.type = 0;
            item.numTags = 0;
            return true;
        }
    };
    private static final int CLOSE_PATH = 7;
    private static final int MOVE_TO = 1;
    private static final int LINE_TO = 2;
    private int lastX;
    private int lastY;

    public TileDecoder() {
        this("");
    }

    public TileDecoder(String locale) {
        this.mLocale = locale;
    }

    @Override
    public boolean decode(Tile tile, ITileDataSink mapDataCallback, InputStream is) throws IOException {
        int val;
        this.setInputStream(is);
        this.mTile = tile;
        this.mMapDataCallback = mapDataCallback;
        this.mScale = 4096.0f / (float)Tile.SIZE;
        block3: while (this.hasData() && (val = this.decodeVarint32()) > 0) {
            int tag = val >> 3;
            switch (tag) {
                case 3: {
                    this.decodeLayer();
                    continue block3;
                }
            }
            this.error(this.mTile + " invalid type for tile: " + tag);
            return false;
        }
        if (this.hasData()) {
            this.error(tile + " invalid tile");
            return false;
        }
        return true;
    }

    private boolean decodeLayer() throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String name = null;
        int numFeatures = 0;
        ArrayList<Feature> features = new ArrayList<Feature>();
        int end = this.position() + bytes;
        block8: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 3: {
                    keys.add(this.decodeString());
                    continue block8;
                }
                case 4: {
                    values.add(this.decodeValue());
                    continue block8;
                }
                case 2: {
                    ++numFeatures;
                    this.decodeFeature(features);
                    continue block8;
                }
                case 15: {
                    this.decodeVarint32();
                    continue block8;
                }
                case 1: {
                    name = this.decodeString();
                    continue block8;
                }
                case 5: {
                    this.decodeVarint32();
                    continue block8;
                }
            }
            this.error(this.mTile + " invalid type for layer: " + tag);
        }
        Tag layerTag = new Tag("layer", name);
        if (numFeatures == 0) {
            return true;
        }
        boolean numIgnore = false;
        short fallBackLocal = -1;
        short matchedLocal = -1;
        for (short i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (!key.startsWith("name")) continue;
            int len = key.length();
            if (len == 4) {
                fallBackLocal = i;
                continue;
            }
            if (len < 7 || !this.mLocale.equals(key.substring(5))) continue;
            matchedLocal = i;
        }
        for (Feature f : features) {
            if (f.elem.type == GeometryBuffer.GeometryType.NONE) continue;
            f.elem.tags.clear();
            f.elem.tags.add(layerTag);
            boolean hasName = false;
            String fallbackName = null;
            for (int j = 0; j < f.numTags << 1; j += 2) {
                short keyIdx = f.tags[j];
                if (keyIdx == fallBackLocal) {
                    fallbackName = (String)values.get(f.tags[j + 1]);
                    continue;
                }
                String val2 = (String)values.get(f.tags[j + 1]);
                if (keyIdx == matchedLocal) {
                    hasName = true;
                    f.elem.tags.add(new Tag("name", val2, false));
                    continue;
                }
                String key = (String)keys.get(keyIdx);
                if (key.startsWith("name")) continue;
                f.elem.tags.add(new Tag(key, val2));
            }
            if (!hasName && fallbackName != null) {
                f.elem.tags.add(new Tag("name", fallbackName, false));
            }
            f.elem.setLayer(5);
            this.mMapDataCallback.process(f.elem);
            f = this.mFeaturePool.release(f);
        }
        return true;
    }

    private void decodeFeature(ArrayList<Feature> features) throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        int end = this.position() + bytes;
        int type = 0;
        this.lastX = 0;
        this.lastY = 0;
        this.mTmpTags[0] = -1;
        Feature curFeature = null;
        int numTags = 0;
        block6: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >>> 3;
            switch (tag) {
                case 1: {
                    this.decodeVarint32();
                    continue block6;
                }
                case 2: {
                    this.mTmpTags = this.decodeUnsignedVarintArray(this.mTmpTags);
                    while (numTags < this.mTmpTags.length && this.mTmpTags[numTags] >= 0) {
                        numTags += 2;
                    }
                    numTags >>= 1;
                    continue block6;
                }
                case 3: {
                    type = this.decodeVarint32();
                    continue block6;
                }
                case 4: {
                    for (Feature f : features) {
                        if (!f.match(this.mTmpTags, numTags, type)) continue;
                        curFeature = f;
                        break;
                    }
                    if (curFeature == null) {
                        curFeature = this.mFeaturePool.get();
                        curFeature.tags = new short[numTags << 1];
                        System.arraycopy(this.mTmpTags, 0, curFeature.tags, 0, numTags << 1);
                        curFeature.numTags = numTags;
                        curFeature.type = type;
                        features.add(curFeature);
                    }
                    this.decodeCoordinates(type, curFeature);
                    continue block6;
                }
            }
            this.error(this.mTile + " invalid type for feature: " + tag);
        }
    }

    private int decodeCoordinates(int type, Feature feature) throws IOException {
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        if (feature == null) {
            this.bufferPos += bytes;
            return 0;
        }
        MapElement elem = feature.elem;
        boolean isPoint = false;
        boolean isPoly = false;
        boolean isLine = false;
        if (type == 2) {
            elem.startLine();
            isLine = true;
        } else if (type == 3) {
            elem.startPolygon();
            isPoly = true;
        } else if (type == 1) {
            isPoint = true;
            elem.startPoints();
        } else if (type == 0) {
            elem.startPoints();
        }
        int curX = 0;
        int curY = 0;
        int prevX = 0;
        int prevY = 0;
        int cmd = 0;
        int repeat = 0;
        int cnt = 0;
        boolean first = true;
        boolean lastClip = false;
        boolean isOuter = true;
        boolean simplify = false;
        int pixel = simplify ? 7 : 3;
        int end = this.bufferPos + bytes;
        while (this.bufferPos < end) {
            int val;
            if (repeat == 0) {
                val = this.decodeVarint32Filled();
                repeat = val >>> 3;
                cnt = 0;
                cmd = val & 7;
                if (isLine && lastClip) {
                    elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
                    lastClip = false;
                }
                if (cmd == 7) {
                    repeat = 0;
                    elem.startHole();
                    continue;
                }
                if (cmd == 1 && type == 2) {
                    elem.startLine();
                }
                if (repeat == 0) continue;
            }
            --repeat;
            val = this.decodeVarint32Filled();
            int s = val >>> 1 ^ -(val & 1);
            curX = this.lastX += s;
            val = this.decodeVarint32Filled();
            s = val >>> 1 ^ -(val & 1);
            curY = this.lastY += s;
            int dx = curX - prevX;
            int dy = curY - prevY;
            prevX = curX;
            prevY = curY;
            if (isPoint || cmd == 1 || cmd == 2) {
                elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
                ++cnt;
                lastClip = false;
                continue;
            }
            lastClip = true;
        }
        if (isLine && lastClip) {
            elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
        }
        return 1;
    }

    private String decodeValue() throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        String value = null;
        int end = this.position() + bytes;
        while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 1: {
                    value = this.decodeString();
                    break;
                }
                case 5: {
                    value = String.valueOf(this.decodeVarint32());
                    break;
                }
                case 6: {
                    value = String.valueOf(TileDecoder.deZigZag(this.decodeVarint32()));
                    break;
                }
                case 4: {
                    value = String.valueOf(this.decodeVarint64());
                    break;
                }
                case 2: {
                    value = String.valueOf(this.decodeFloat());
                    break;
                }
                case 3: {
                    value = String.valueOf(this.decodeDouble());
                    break;
                }
                case 7: {
                    value = this.decodeBool() ? "yes" : "no";
                    break;
                }
            }
        }
        return value;
    }

    static class Feature
    extends Inlist<Feature> {
        short[] tags;
        int numTags;
        int type;
        final MapElement elem = new MapElement();

        Feature() {
        }

        boolean match(short[] otherTags, int otherNumTags, int otherType) {
            if (this.numTags != otherNumTags) {
                return false;
            }
            if (this.type != otherType) {
                return false;
            }
            for (int i = 0; i < this.numTags << 1; ++i) {
                if (this.tags[i] == otherTags[i]) continue;
                return false;
            }
            return true;
        }
    }
}

