/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.test;

import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.TileSource;

public class TestTileSource
extends TileSource {
    public TestTileSource() {
        super(0, 18);
    }

    @Override
    public ITileDataSource getDataSource() {
        return new TileDataSource();
    }

    @Override
    public TileSource.OpenResult open() {
        return TileSource.OpenResult.SUCCESS;
    }

    @Override
    public void close() {
    }

    static class TileDataSource
    implements ITileDataSource {
        private static final Tag[] mTags = new Tag[]{new Tag("natural", "water")};
        private static final Tag[] mTagsWay = new Tag[]{new Tag("highway", "primary"), new Tag("name", "Highway Rd")};
        private static final Tag[] mTagsBoundary = new Tag[]{new Tag("boundary", "administrative"), new Tag("admin_level", "2")};
        private static final Tag[] mTagsPlace = new Tag[]{new Tag("place", "city"), null};
        private final MapElement mElem = new MapElement();
        private boolean renderWays = true;
        private boolean renderBoundary = true;
        private boolean renderPlace = false;

        @Override
        public void query(MapTile tile, ITileDataSink sink) {
            int size = Tile.SIZE;
            MapElement e = this.mElem;
            float x1 = -1.0f;
            float y1 = -1.0f;
            float x2 = size + 1;
            float y2 = size + 1;
            e.clear();
            e.startPolygon();
            e.addPoint(x1, y1);
            e.addPoint(x2, y1);
            e.addPoint(x2, y2);
            e.addPoint(x1, y2);
            y1 = 5.0f;
            y2 = size - 5;
            x1 = 5.0f;
            x2 = size - 5;
            e.startHole();
            e.addPoint(x1, y1);
            e.addPoint(x2, y1);
            e.addPoint(x2, y2);
            e.addPoint(x1, y2);
            e.setLayer(0);
            e.tags.set(mTags);
            sink.process(e);
            if (this.renderWays) {
                e.clear();
                e.startLine();
                e.addPoint(0.0f, size / 2);
                e.addPoint(size, size / 2);
                e.startLine();
                e.addPoint(size / 2, -size / 2);
                e.addPoint(size / 2, size / 2);
                e.startLine();
                e.addPoint(size / 2, size / 2);
                e.addPoint(size / 2, size / 2 + size);
                sink.process(e);
                e.clear();
                e.startLine();
                e.addPoint(size / 2, size / 2);
                e.addPoint(10.0f, 10.0f);
                e.startLine();
                e.addPoint(0.0f, 10.0f);
                e.addPoint(size, 10.0f);
                e.startLine();
                e.addPoint(10.0f, 0.0f);
                e.addPoint(10.0f, size);
                e.setLayer(1);
                e.tags.set(mTagsWay);
                sink.process(e);
            }
            if (this.renderBoundary) {
                e.clear();
                e.startPolygon();
                float r = size / 2;
                for (int i = 0; i < 360; i += 4) {
                    double d = Math.toRadians(i);
                    e.addPoint(r + (float)Math.cos(d) * (r - 40.0f), r + (float)Math.sin(d) * (r - 40.0f));
                }
                e.setLayer(1);
                e.tags.set(mTagsBoundary);
                sink.process(e);
            }
            if (this.renderPlace) {
                e.clear();
                e.startPoints();
                e.addPoint(size / 2, size / 2);
                TileDataSource.mTagsPlace[1] = new Tag("name", tile.toString());
                e.tags.set(mTagsPlace);
                sink.process(e);
            }
            sink.completed(QueryResult.SUCCESS);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void cancel() {
        }
    }
}

