/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

public class MinHeap {
    private int[] data;
    private float[] heap;
    int size;
    private final Item it = new Item();

    public MinHeap(float[] heap, int[] data) {
        this.heap = heap;
        this.data = data;
        this.size = 1;
    }

    public void push(float prio, int d) {
        int idx = this.size++;
        int n = idx >> 1;
        while (idx > 1 && this.heap[n] > prio) {
            this.heap[idx] = this.heap[n];
            this.data[idx] = this.data[n];
            idx = n;
            n >>= 1;
        }
        this.heap[idx] = prio;
        this.data[idx] = d;
    }

    public Item pop() {
        int idx;
        if (this.size == 1) {
            return null;
        }
        this.it.pos = this.data[1];
        this.it.prio = this.heap[1];
        if ((idx = --this.size) > 1) {
            this.heap[1] = this.heap[idx];
            this.data[1] = this.data[idx];
            this.heapify();
        }
        return this.it;
    }

    public int peek() {
        return this.data[1];
    }

    private void heapify() {
        int c;
        float root = this.heap[1];
        int tmp = this.data[1];
        int last = this.size;
        int idx = 1;
        while ((c = idx << 1) <= last) {
            float val;
            if (c + 1 <= last && this.heap[c + 1] < this.heap[c]) {
                ++c;
            }
            if ((val = this.heap[c]) >= root) break;
            this.heap[idx] = val;
            this.data[idx] = this.data[c];
            idx = c;
        }
        this.heap[idx] = root;
        this.data[idx] = tmp;
    }

    public static void main(String[] args) {
        MinHeap h = new MinHeap(new float[10], new int[10]);
        h.push(10.0f, 10);
        h.push(12.0f, 12);
        h.push(21.0f, 21);
        h.push(31.0f, 31);
        h.push(14.0f, 14);
        h.push(2.0f, 2);
        for (int i = 0; i < 10; ++i) {
            Item it = h.pop();
            if (it == null) continue;
            System.out.println(it.pos + " " + it.prio);
        }
    }

    public static final class Item {
        public int pos;
        public float prio;
        public int index;
    }
}

