/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.Arrays;
import org.oscim.utils.RTree;

class Partition {
    int total;
    int minFill;
    final int[] partition;
    final boolean[] taken;
    final int[] count;
    final RTree.Rect[] cover;
    final double[] area;
    final RTree.Rect coverSplit;
    double coverSplitArea;
    final RTree.Branch<Object>[] branchBuf;
    final double[] mTmpArea;

    public Partition clear() {
        int maxnodes = this.branchBuf.length;
        for (int i = 0; i < maxnodes; ++i) {
            this.taken[i] = false;
            this.partition[i] = -1;
        }
        this.count[1] = 0;
        this.count[0] = 0;
        this.area[1] = 0.0;
        this.area[0] = 0.0;
        this.total = maxnodes;
        return this;
    }

    public Partition(int maxnodes, int minnodes) {
        this.partition = new int[maxnodes + 1];
        this.taken = new boolean[maxnodes + 1];
        this.count = new int[2];
        this.area = new double[2];
        this.branchBuf = new RTree.Branch[maxnodes + 1];
        this.cover = new RTree.Rect[]{new RTree.Rect(), new RTree.Rect()};
        this.coverSplit = new RTree.Rect();
        this.minFill = minnodes;
        this.mTmpArea = new double[maxnodes + 1];
    }

    void loadNodes(RTree.Node nodeA, RTree.Node nodeB) {
        assert (nodeA != null);
        assert (nodeB != null);
        block4: for (int idx = 0; idx < this.total; ++idx) {
            switch (this.partition[idx]) {
                case 0: {
                    nodeA.addBranch(this.branchBuf[idx]);
                    continue block4;
                }
                case 1: {
                    nodeB.addBranch(this.branchBuf[idx]);
                }
            }
        }
    }

    void getBranches(RTree.Node node, RTree.Branch<?> branch) {
        int idx;
        assert (node != null);
        assert (branch != null);
        assert (node.count == node.branch.length);
        for (idx = 0; idx < node.count; ++idx) {
            this.branchBuf[idx] = node.branch[idx];
        }
        this.branchBuf[node.count] = branch;
        this.coverSplit.set(this.branchBuf[0]);
        int n = this.branchBuf.length;
        for (idx = 1; idx < n; ++idx) {
            this.coverSplit.add(this.branchBuf[idx]);
        }
        this.coverSplitArea = this.coverSplit.calcRectVolume();
        node.count = 0;
        node.level = -1;
    }

    private void classify(int idx, int group) {
        if (this.taken[idx]) {
            throw new IllegalStateException("Index already used!" + idx + " " + Arrays.toString(this.taken));
        }
        this.partition[idx] = group;
        this.taken[idx] = true;
        if (this.count[group] == 0) {
            this.cover[group].set(this.branchBuf[idx]);
        } else {
            this.cover[group].add(this.branchBuf[idx]);
        }
        this.area[group] = this.cover[group].calcRectVolume();
        int n = group;
        this.count[n] = this.count[n] + 1;
    }

    private void pickSeeds() {
        int seed0 = 0;
        int seed1 = 1;
        double[] tmpArea = this.mTmpArea;
        for (int idx = 0; idx < this.total; ++idx) {
            tmpArea[idx] = this.branchBuf[idx].calcRectVolume();
        }
        double worst = -this.coverSplitArea - 1.0;
        for (int idxA = 0; idxA < this.total - 1; ++idxA) {
            for (int idxB = idxA + 1; idxB < this.total; ++idxB) {
                double waste = RTree.mergedArea(this.branchBuf[idxA], this.branchBuf[idxB]) - (tmpArea[idxA] + tmpArea[idxB]);
                if (!(waste > worst)) continue;
                worst = waste;
                seed0 = idxA;
                seed1 = idxB;
            }
        }
        this.classify(seed0, 0);
        this.classify(seed1, 1);
    }

    void choosePartition() {
        int group;
        int chosen = 0;
        int betterGroup = 0;
        this.pickSeeds();
        while (this.count[0] + this.count[1] < this.total && this.count[0] < this.total - this.minFill && this.count[1] < this.total - this.minFill) {
            double biggestDiff = -1.0;
            for (int idx = 0; idx < this.total; ++idx) {
                if (this.taken[idx]) continue;
                double growth0 = RTree.mergedArea(this.branchBuf[idx], this.cover[0]) - this.area[0];
                double growth1 = RTree.mergedArea(this.branchBuf[idx], this.cover[1]) - this.area[1];
                double diff = growth1 - growth0;
                if (diff >= 0.0) {
                    group = 0;
                } else {
                    group = 1;
                    diff = -diff;
                }
                if (diff > biggestDiff) {
                    biggestDiff = diff;
                    chosen = idx;
                    betterGroup = group;
                    continue;
                }
                if (diff != biggestDiff || this.count[group] >= this.count[betterGroup]) continue;
                chosen = idx;
                betterGroup = group;
            }
            this.classify(chosen, betterGroup);
        }
        if (this.count[0] + this.count[1] < this.total) {
            group = this.count[0] >= this.total - this.minFill ? 1 : 0;
            for (int index = 0; index < this.total; ++index) {
                if (this.taken[index]) continue;
                this.classify(index, group);
            }
        }
        assert (this.count[0] + this.count[1] == this.total);
        assert (this.count[0] >= this.minFill && this.count[1] >= this.minFill);
    }
}

