/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

public class UTF8Decoder {
    private static final char REPLACEMENT_CHAR = '\ufffd';
    char[] mBuffer;
    int mBufferSize = 0;

    public String decode(byte[] data, int offset, int byteCount) {
        if ((offset | byteCount) < 0 || byteCount > data.length - offset) {
            throw new IllegalArgumentException("Brrr " + data.length + " " + offset + " " + byteCount);
        }
        byte[] d = data;
        char[] v = this.mBufferSize < byteCount ? (this.mBuffer = new char[byteCount]) : this.mBuffer;
        int idx = offset;
        int last = offset + byteCount;
        int s = 0;
        block0: while (idx < last) {
            byte b0;
            if (((b0 = d[idx++]) & 0x80) == 0) {
                int val = b0 & 0xFF;
                v[s++] = (char)val;
                continue;
            }
            if ((b0 & 0xE0) == 192 || (b0 & 0xF0) == 224 || (b0 & 0xF8) == 240 || (b0 & 0xFC) == 248 || (b0 & 0xFE) == 252) {
                int utfCount = 1;
                if ((b0 & 0xF0) == 224) {
                    utfCount = 2;
                } else if ((b0 & 0xF8) == 240) {
                    utfCount = 3;
                } else if ((b0 & 0xFC) == 248) {
                    utfCount = 4;
                } else if ((b0 & 0xFE) == 252) {
                    utfCount = 5;
                }
                if (idx + utfCount > last) {
                    v[s++] = 65533;
                    break;
                }
                int val = b0 & 31 >> utfCount - 1;
                for (int i = 0; i < utfCount; ++i) {
                    byte b;
                    if (((b = d[idx++]) & 0xC0) != 128) {
                        v[s++] = 65533;
                        --idx;
                        continue block0;
                    }
                    val <<= 6;
                    val |= b & 0x3F;
                }
                if (utfCount != 2 && val >= 55296 && val <= 57343) {
                    v[s++] = 65533;
                    continue;
                }
                if (val > 0x10FFFF) {
                    v[s++] = 65533;
                    continue;
                }
                if (val < 65536) {
                    v[s++] = (char)val;
                    continue;
                }
                int x = val & 0xFFFF;
                int u = val >> 16 & 0x1F;
                int w = u - 1 & 0xFFFF;
                int hi = 0xD800 | w << 6 | x >> 10;
                int lo = 0xDC00 | x & 0x3FF;
                v[s++] = (char)hi;
                v[s++] = (char)lo;
                continue;
            }
            v[s++] = 65533;
        }
        return new String(v, 0, s);
    }
}

