/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

public final class GeometryUtils {
    private GeometryUtils() {
    }

    public static boolean pointInPoly(float x, float y, float[] vertices, int length, int offset) {
        int end = offset + length;
        boolean inside = false;
        int j = end - 2;
        for (int i = offset; i < end; i += 2) {
            if (vertices[i + 1] > y != vertices[j + 1] > y && x < (vertices[j] - vertices[i]) * (y - vertices[i + 1]) / (vertices[j + 1] - vertices[i + 1]) + vertices[i]) {
                inside = !inside;
            }
            j = i;
        }
        return inside;
    }

    public static float area(float ax, float ay, float bx, float by, float cx, float cy) {
        float area = (ax - cx) * (by - cy) - (bx - cx) * (ay - cy);
        return (area < 0.0f ? -area : area) * 0.5f;
    }

    public static float area(float[] a, int p1, int p2, int p3) {
        float area = (a[p1] - a[p3]) * (a[p2 + 1] - a[p3 + 1]) - (a[p2] - a[p3]) * (a[p1 + 1] - a[p3 + 1]);
        return (area < 0.0f ? -area : area) * 0.5f;
    }

    public static float squaredDistance(float[] p, int a, int b) {
        return (p[a] - p[b]) * (p[a] - p[b]) + (p[a + 1] - p[b + 1]) * (p[a + 1] - p[b + 1]);
    }

    public static float squareSegmentDistance(float[] p, int a, int b, int c) {
        float x = p[b];
        float y = p[b + 1];
        float dx = p[c] - x;
        float dy = p[c + 1] - y;
        if (dx != 0.0f || dy != 0.0f) {
            float t = ((p[a] - x) * dx + (p[a + 1] - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0f) {
                x = p[c];
                y = p[c + 1];
            } else if (t > 0.0f) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = p[a] - x;
        dy = p[a + 1] - y;
        return dx * dx + dy * dy;
    }

    public static double distance(float[] p, int a, int b) {
        float dx = p[a] - p[b];
        float dy = p[a + 1] - p[b + 1];
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double dotProduct(float[] p, int a, int b, int c) {
        double vy;
        double vx;
        double bc;
        double ux = p[b] - p[a];
        double uy = p[b + 1] - p[a + 1];
        double ab = Math.sqrt(ux * ux + uy * uy);
        double d = ab * (bc = Math.sqrt((vx = (double)(p[b] - p[c])) * vx + (vy = (double)(p[b + 1] - p[c + 1])) * vy));
        if (d <= 0.0) {
            return 0.0;
        }
        double dotp = (ux * -vx + uy * -vy) / d;
        if (dotp > 1.0) {
            dotp = 1.0;
        } else if (dotp < -1.0) {
            dotp = -1.0;
        }
        return dotp;
    }

    public static void main(String[] args) {
        float[] p = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        for (int i = 0; i < 9; ++i) {
            p[4] = (float)Math.cos(Math.toRadians(i * 45));
            p[5] = (float)Math.sin(Math.toRadians(i * 45));
            System.out.println("\n> " + i * 45 + " " + p[3] + ":" + p[4] + "\n=" + GeometryUtils.dotProduct(p, 0, 2, 4));
        }
    }
}

