/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;
import org.oscim.utils.geom.GeometryUtils;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;

public class SimplifyVW {
    Pool<Item> pool = new Pool<Item>(){

        @Override
        protected Item createItem() {
            return new Item();
        }
    };
    private Item[] heap = new Item[100];
    private int size = 0;

    public void simplify(GeometryBuffer geom, float minArea) {
        Item it;
        Item prev = null;
        Item first = null;
        this.size = 0;
        if (this.heap.length < geom.pointPos >> 1) {
            this.heap = new Item[geom.pointPos >> 1];
        }
        first = prev = this.push(0, Float.MAX_VALUE);
        for (int i = 2; i < geom.pointPos - 2; i += 2) {
            it = this.push(i, SimplifyVW.area(geom.points, i - 2, i, i + 2));
            prev.next = it;
            it.prev = prev;
            prev = it;
        }
        Item last = this.push(geom.pointPos - 2, Float.MAX_VALUE);
        last.prev = prev;
        prev.next = last;
        last.next = first;
        first.prev = last;
        while ((it = this.pop()) != null && !(it.area > minArea) && it.prev != it.next) {
            it.prev.next = it.next;
            ((Item)it.next).prev = it.prev;
            if (it.prev != first) {
                this.update(geom, it.prev);
            }
            if (it.next != first) {
                this.update(geom, (Item)it.next);
            }
            it = this.pool.release(it);
        }
        first.prev.next = null;
        first.prev = null;
        it = first;
        float[] points = new float[geom.pointPos];
        System.arraycopy(geom.points, 0, points, 0, geom.pointPos);
        geom.clear();
        geom.startPolygon();
        while (it != null) {
            float x = points[it.id];
            float y = points[it.id + 1];
            geom.addPoint(x, y);
            it = (Item)it.next;
        }
        first = this.pool.release(first);
    }

    public static float area(float[] a, int p1, int p2, int p3) {
        float area = GeometryUtils.area(a, p1, p2, p3);
        double dotp = GeometryUtils.dotProduct(a, p1, p2, p3);
        double weight = (dotp = Math.abs(dotp)) < 0.5 ? 0.1 : (dotp < 1.0 ? 0.3 : 1.0);
        return (float)((double)area * weight);
    }

    private void update(GeometryBuffer geom, Item it) {
        float area = SimplifyVW.area(geom.points, it.prev.id, it.id, ((Item)it.next).id);
        this.update(it, area);
    }

    public void push(Item it) {
        this.heap[this.size] = it;
        it.index = this.size;
        this.up(this.size++);
    }

    public Item push(int id, float area) {
        Item it;
        this.heap[this.size] = it = this.pool.get();
        it.index = this.size;
        it.area = area;
        it.id = id;
        this.up(this.size++);
        return it;
    }

    public Item pop() {
        if (this.size == 0) {
            return null;
        }
        Item removed = this.heap[0];
        Item obj = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size > 0) {
            obj.index = 0;
            this.heap[0] = obj;
            this.down(0);
        }
        return removed;
    }

    public void update(Item it, float area) {
        if (area < it.area) {
            it.area = area;
            this.up(it.index);
        } else {
            it.area = area;
            this.down(it.index);
        }
    }

    public int remove(Item removed) {
        if (this.size == 0) {
            throw new IllegalStateException("size == 0");
        }
        int i = removed.index;
        Item obj = this.heap[--this.size];
        this.heap[this.size] = null;
        if (i == this.size) {
            return i;
        }
        obj.index = i;
        this.heap[i] = obj;
        if (obj.area < removed.area) {
            this.up(i);
        } else {
            this.down(i);
        }
        return i;
    }

    private void up(int i) {
        Item it = this.heap[i];
        while (i > 0) {
            int up = (i + 1 >> 1) - 1;
            Item parent = this.heap[up];
            if (it.area >= parent.area) break;
            parent.index = i;
            this.heap[i] = parent;
            it.index = i = up;
            this.heap[i] = it;
        }
    }

    private void down(int i) {
        Item it = this.heap[i];
        while (true) {
            int right = i + 1 << 1;
            int left = right - 1;
            int down = i;
            Item child = this.heap[down];
            if (left < this.size && this.heap[left].area < child.area) {
                down = left;
                child = this.heap[down];
            }
            if (right < this.size && this.heap[right].area < child.area) {
                down = right;
                child = this.heap[down];
            }
            if (down == i) break;
            child.index = i;
            this.heap[child.index] = child;
            it.index = i = down;
            this.heap[i] = it;
        }
    }

    class Item
    extends Inlist<Item> {
        int index;
        int id;
        float area;
        Item prev;

        Item() {
        }
    }
}

