/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.pool;

import javax.annotation.CheckReturnValue;
import org.oscim.utils.pool.Inlist;

public abstract class Pool<T extends Inlist<?>> {
    protected T mPool;
    protected int mLimit;
    protected int mFill;

    protected boolean clearItem(T item) {
        return true;
    }

    @CheckReturnValue
    public T release(T item) {
        if (item == null) {
            return null;
        }
        if (!this.clearItem(item)) {
            return null;
        }
        ((Inlist)item).next = this.mPool;
        this.mPool = item;
        return null;
    }

    @CheckReturnValue
    public T releaseAll(T list) {
        if (list == null) {
            return null;
        }
        while (list != null) {
            Object next = ((Inlist)list).next;
            this.clearItem(list);
            ((Inlist)list).next = this.mPool;
            this.mPool = list;
            list = next;
        }
        return null;
    }

    public T release(T list, T item) {
        if (item == null) {
            return list;
        }
        this.clearItem(item);
        return Inlist.remove(list, item);
    }

    public T get() {
        if (this.mPool == null) {
            return this.createItem();
        }
        T ret = this.mPool;
        this.mPool = ((Inlist)this.mPool).next;
        ((Inlist)ret).next = null;
        return ret;
    }

    protected abstract T createItem();
}

