/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.quadtree;

import org.oscim.utils.quadtree.TreeNode;

public abstract class TileIndex<T extends TreeNode<T, E>, E> {
    protected final T root = this.create();
    protected T pool;

    public TileIndex() {
        ((TreeNode)this.root).id = -1;
        ((TreeNode)this.root).parent = this.root;
    }

    static void checkIndex(int x, int y, int max) {
        if (x < 0 || x >= max || y < 0 || y >= max) {
            throw new IllegalArgumentException("invalid position " + x + '/' + y + '/' + (max >> 1));
        }
    }

    public abstract T create();

    public abstract void removeItem(E var1);

    public T add(int x, int y, int z) {
        TileIndex.checkIndex(x, y, 1 << z);
        if (z == 0) {
            return this.root;
        }
        T leaf = this.root;
        for (int level = z - 1; level >= 0; --level) {
            int id = x >> level & 1 | (y >> level & 1) << 1;
            ++((TreeNode)leaf).refs;
            Object cur = null;
            switch (id) {
                case 0: {
                    cur = ((TreeNode)leaf).child00;
                    break;
                }
                case 1: {
                    cur = ((TreeNode)leaf).child01;
                    break;
                }
                case 2: {
                    cur = ((TreeNode)leaf).child10;
                    break;
                }
                case 3: {
                    cur = ((TreeNode)leaf).child11;
                }
            }
            if (cur != null) {
                leaf = cur;
                continue;
            }
            if (this.pool != null) {
                cur = this.pool;
                this.pool = ((TreeNode)this.pool).parent;
            } else {
                cur = this.create();
            }
            cur.refs = 0;
            cur.id = (byte)id;
            cur.parent = leaf;
            switch (id) {
                case 0: {
                    ((TreeNode)cur.parent).child00 = cur;
                    break;
                }
                case 1: {
                    ((TreeNode)cur.parent).child01 = cur;
                    break;
                }
                case 2: {
                    ((TreeNode)cur.parent).child10 = cur;
                    break;
                }
                case 3: {
                    ((TreeNode)cur.parent).child11 = cur;
                }
            }
            leaf = cur;
        }
        ++((TreeNode)leaf).refs;
        return leaf;
    }

    public E getTile(int x, int y, int z) {
        TileIndex.checkIndex(x, y, 1 << z);
        if (z == 0) {
            return ((TreeNode)this.root).item;
        }
        T leaf = this.root;
        for (int level = z - 1; level >= 0; --level) {
            int id = x >> level & 1 | (y >> level & 1) << 1;
            switch (id) {
                case 0: {
                    leaf = ((TreeNode)leaf).child00;
                    break;
                }
                case 1: {
                    leaf = ((TreeNode)leaf).child01;
                    break;
                }
                case 2: {
                    leaf = ((TreeNode)leaf).child10;
                    break;
                }
                case 3: {
                    leaf = ((TreeNode)leaf).child11;
                }
            }
            if (leaf == null) {
                return null;
            }
            if (level != 0) continue;
            return ((TreeNode)leaf).item;
        }
        return null;
    }

    public boolean remove(T item) {
        T cur = item;
        while (cur != this.root) {
            if (cur == null) {
                throw new IllegalStateException("Item not in index");
            }
            Object next = ((TreeNode)cur).parent;
            --((TreeNode)cur).refs;
            if (((TreeNode)cur).refs == 0) {
                switch (((TreeNode)cur).id) {
                    case 0: {
                        ((TreeNode)next).child00 = null;
                        break;
                    }
                    case 1: {
                        ((TreeNode)next).child01 = null;
                        break;
                    }
                    case 2: {
                        ((TreeNode)next).child10 = null;
                        break;
                    }
                    case 3: {
                        ((TreeNode)next).child11 = null;
                    }
                }
                ((TreeNode)cur).parent = this.pool;
                this.pool = cur;
            }
            cur = next;
        }
        --((TreeNode)this.root).refs;
        return true;
    }

    public int size() {
        return ((TreeNode)this.root).refs;
    }

    public void drop() {
        ((TreeNode)this.root).item = null;
        ((TreeNode)this.root).child00 = null;
        ((TreeNode)this.root).child01 = null;
        ((TreeNode)this.root).child10 = null;
        ((TreeNode)this.root).child11 = null;
    }
}

