/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

public class Tile {
    private static final int DEFAULT_TILE_SIZE = 256;
    public static int SIZE = 512;
    public static int TILE_SIZE_MULTIPLE = 64;
    public final int tileX;
    public final int tileY;
    public final byte zoomLevel;
    private int mHash = 0;

    public Tile(int tileX, int tileY, byte zoomLevel) {
        this.tileX = tileX;
        this.tileY = tileY;
        this.zoomLevel = zoomLevel;
    }

    public String toString() {
        return "[X:" + this.tileX + ", Y:" + this.tileY + ", Z:" + this.zoomLevel + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tile)) {
            return false;
        }
        Tile o = (Tile)obj;
        return o.tileX == this.tileX && o.tileY == this.tileY && o.zoomLevel == this.zoomLevel;
    }

    public int hashCode() {
        if (this.mHash == 0) {
            int result = 7;
            result = 31 * result + this.tileX;
            result = 31 * result + this.tileY;
            this.mHash = result = 31 * result + this.zoomLevel;
        }
        return this.mHash;
    }

    public static int calculateTileSize(float scaleFactor) {
        float scaled = 256.0f * scaleFactor;
        return Math.max(TILE_SIZE_MULTIPLE, Math.round(scaled / (float)TILE_SIZE_MULTIPLE) * TILE_SIZE_MULTIPLE);
    }
}

