/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.buildings.BuildingRenderer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.pool.Inlist;

public class BuildingLayer
extends Layer
implements VectorTileLayer.TileLoaderThemeHook {
    private static final int MIN_ZOOM = 17;
    private static final int MAX_ZOOM = 17;
    private static final boolean POST_AA = false;
    public static boolean TRANSLUCENT = true;
    public static int DEFAULT_HEIGHT = 12;
    private static final Object BUILDING_DATA = BuildingLayer.class.getName();

    public BuildingLayer(Map map, VectorTileLayer tileLayer) {
        this(map, tileLayer, 17, 17);
    }

    public BuildingLayer(Map map, VectorTileLayer tileLayer, int zoomMin, int zoomMax) {
        super(map);
        tileLayer.addHook(this);
        this.mRenderer = new BuildingRenderer(tileLayer.tileRenderer(), zoomMin, zoomMax, false, TRANSLUCENT);
    }

    @Override
    public boolean process(MapTile tile, RenderBuckets buckets, MapElement element, RenderStyle style, int level) {
        if (!(style instanceof ExtrusionStyle)) {
            return false;
        }
        ExtrusionStyle extrusion = (ExtrusionStyle)style.current();
        int height = 0;
        int minHeight = 0;
        String v = element.tags.getValue("height");
        if (v != null) {
            height = (int)Float.parseFloat(v);
        }
        if ((v = element.tags.getValue("min_height")) != null) {
            minHeight = (int)Float.parseFloat(v);
        }
        if (height == 0) {
            height = DEFAULT_HEIGHT * 100;
        }
        ExtrusionBuckets ebs = BuildingLayer.get(tile);
        for (ExtrusionBucket b = ebs.buckets; b != null; b = b.next()) {
            if (b.colors != extrusion.colors) continue;
            b.add(element, height, minHeight);
            return true;
        }
        double lat = MercatorProjection.toLatitude(tile.y);
        float groundScale = (float)MercatorProjection.groundResolution(lat, 1 << tile.zoomLevel);
        ebs.buckets = Inlist.push(ebs.buckets, new ExtrusionBucket(0, groundScale, extrusion.colors));
        ebs.buckets.add(element, height, minHeight);
        return true;
    }

    public static ExtrusionBuckets get(MapTile tile) {
        ExtrusionBuckets eb = (ExtrusionBuckets)tile.getData(BUILDING_DATA);
        if (eb == null) {
            eb = new ExtrusionBuckets(tile);
            tile.addData(BUILDING_DATA, eb);
        }
        return eb;
    }

    @Override
    public void complete(MapTile tile, boolean success) {
        if (success) {
            BuildingLayer.get(tile).prepare();
        } else {
            BuildingLayer.get(tile).setBuckets(null);
        }
    }
}

