/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.PointF;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelTileData;
import org.oscim.layers.tile.vector.labeling.WayDecorator;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.geom.PolyLabel;

public class LabelTileLoaderHook
implements VectorTileLayer.TileLoaderThemeHook {
    private LabelTileData get(MapTile tile) {
        LabelTileData ld = (LabelTileData)tile.getData(LabelLayer.LABEL_DATA);
        if (ld == null) {
            ld = new LabelTileData();
            tile.addData(LabelLayer.LABEL_DATA, ld);
        }
        return ld;
    }

    @Override
    public boolean process(MapTile tile, RenderBuckets buckets, MapElement element, RenderStyle style, int level) {
        if (style instanceof TextStyle) {
            LabelTileData ld = this.get(tile);
            TextStyle text = (TextStyle)style.current();
            if (element.type == GeometryBuffer.GeometryType.LINE) {
                String value = element.tags.getValue(text.textKey);
                if (value == null || value.length() == 0) {
                    return false;
                }
                int offset = 0;
                for (int length : element.index) {
                    if (length < 4) break;
                    WayDecorator.renderText(null, element.points, value, text, offset, length, ld);
                    offset += length;
                }
            } else if (element.type == GeometryBuffer.GeometryType.POLY) {
                float area;
                float ratio;
                String value = element.tags.getValue(text.textKey);
                if (value == null || value.length() == 0) {
                    return false;
                }
                PointF label = element.labelPosition;
                if (label != null && (label.x < 0.0f || label.x > (float)Tile.SIZE || label.y < 0.0f || label.y > (float)Tile.SIZE)) {
                    return false;
                }
                if (text.areaSize > 0.0f && (ratio = (area = element.area()) / (float)(Tile.SIZE * Tile.SIZE)) < text.areaSize) {
                    return false;
                }
                if (label == null) {
                    label = PolyLabel.get(element);
                }
                ld.labels.push(TextItem.pool.get().set(label.x, label.y, value, text));
            } else if (element.type == GeometryBuffer.GeometryType.POINT) {
                String value = element.tags.getValue(text.textKey);
                if (value == null || value.length() == 0) {
                    return false;
                }
                int n = element.getNumPoints();
                for (int i = 0; i < n; ++i) {
                    PointF p = element.getPoint(i);
                    ld.labels.push(TextItem.pool.get().set(p.x, p.y, value, text));
                }
            }
        } else if (style instanceof SymbolStyle) {
            SymbolStyle symbol = (SymbolStyle)style.current();
            if (symbol.bitmap == null && symbol.texture == null) {
                return false;
            }
            LabelTileData ld = this.get(tile);
            if (element.type == GeometryBuffer.GeometryType.POINT) {
                int n = element.getNumPoints();
                for (int i = 0; i < n; ++i) {
                    PointF p = element.getPoint(i);
                    SymbolItem it = SymbolItem.pool.get();
                    if (symbol.bitmap != null) {
                        it.set(p.x, p.y, symbol.bitmap, true);
                    } else {
                        it.set(p.x, p.y, symbol.texture, true);
                    }
                    ld.symbols.push(it);
                }
            } else if (element.type != GeometryBuffer.GeometryType.LINE && element.type == GeometryBuffer.GeometryType.POLY) {
                PointF centroid = element.labelPosition;
                if (centroid == null) {
                    return false;
                }
                if (centroid.x < 0.0f || centroid.x > (float)Tile.SIZE || centroid.y < 0.0f || centroid.y > (float)Tile.SIZE) {
                    return false;
                }
                SymbolItem it = SymbolItem.pool.get();
                if (symbol.bitmap != null) {
                    it.set(centroid.x, centroid.y, symbol.bitmap, true);
                } else {
                    it.set(centroid.x, centroid.y, symbol.texture, true);
                }
                ld.symbols.push(it);
            }
        }
        return false;
    }

    @Override
    public void complete(MapTile tile, boolean success) {
    }
}

