/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Color;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.utils.ArrayUtils;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.LineClipper;
import org.oscim.utils.math.Interpolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolygonBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(PolygonBucket.class);
    public static final int CLIP_STENCIL = 1;
    public static final int CLIP_DEPTH = 2;
    public static final int CLIP_TEST_DEPTH = 3;
    public static boolean enableTexture = true;
    public AreaStyle area;
    float xmin = 32767.0f;
    float ymin = 32767.0f;
    float xmax = -32768.0f;
    float ymax = -32768.0f;
    final float[] bbox = new float[8];

    PolygonBucket(int layer) {
        super(2, true, false);
        this.level = layer;
    }

    public void addPolygon(GeometryBuffer geom) {
        this.addPolygon(geom.points, geom.index);
    }

    public void addPolygon(float[] points, int[] index) {
        short center = (short)((float)(Tile.SIZE >> 1) * MapRenderer.COORD_SCALE);
        boolean outline = this.area.strokeWidth > 0.0f;
        int pos = 0;
        for (int length : index) {
            if (length < 0) break;
            if (length < 6) {
                pos += length;
                continue;
            }
            this.vertexItems.add(center, center);
            ++this.numVertices;
            int inPos = pos;
            for (int j = 0; j < length; j += 2) {
                float x = points[inPos++] * MapRenderer.COORD_SCALE;
                float y = points[inPos++] * MapRenderer.COORD_SCALE;
                this.xmax = Math.max(this.xmax, x);
                this.xmin = Math.min(this.xmin, x);
                this.ymax = Math.max(this.ymax, y);
                this.ymin = Math.min(this.ymin, y);
                if (outline) {
                    this.indiceItems.add((short)this.numVertices);
                    ++this.numIndices;
                }
                this.vertexItems.add((short)x, (short)y);
                ++this.numVertices;
                if (!outline) continue;
                this.indiceItems.add((short)this.numVertices);
                ++this.numIndices;
            }
            this.vertexItems.add((short)(points[pos + 0] * MapRenderer.COORD_SCALE), (short)(points[pos + 1] * MapRenderer.COORD_SCALE));
            ++this.numVertices;
            pos += length;
        }
    }

    @Override
    protected void prepare() {
        ArrayUtils.setBox2D(this.bbox, this.xmin, this.ymin, this.xmax, this.ymax);
    }

    @Override
    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        if (this.area.strokeWidth == 0.0f) {
            this.compileVertexItems(vboData);
        } else {
            super.compile(vboData, iboData);
        }
    }

    public static final class Renderer {
        private static final int STENCIL_BITS = 8;
        public static final int CLIP_BIT = 128;
        private static PolygonBucket[] mAreaLayer;
        private static Shader polyShader;
        private static Shader texShader;
        private static int mCount;
        private static boolean mClear;
        static float[] mBBox;
        static LineClipper mScreenClip;

        static boolean init() {
            polyShader = new Shader("base_shader");
            texShader = new Shader("polygon_layer_tex");
            mAreaLayer = new PolygonBucket[8];
            return true;
        }

        private static void fillPolygons(GLViewport v, int start, int end, MapPosition pos, float div) {
            GLAdapter.gl.colorMask(true, true, true, true);
            GLAdapter.gl.stencilMask(0);
            for (int i = start; i < end; ++i) {
                boolean blend;
                Shader s;
                PolygonBucket l = mAreaLayer[i];
                AreaStyle a = l.area.current();
                if (enableTexture && a.texture != null) {
                    s = Renderer.setShader(texShader, v.mvp, false);
                    float num = FastMath.clamp(Tile.SIZE / a.texture.width >> 1, 1, Tile.SIZE);
                    float scale = (float)pos.getZoomScale();
                    float transition = FastMath.clamp(scale - 1.0f, 0.0f, 1.0f);
                    transition = Interpolation.exp5.apply(transition);
                    GLAdapter.gl.uniform2f(s.uScale, transition, div / num);
                    a.texture.bind();
                } else {
                    s = Renderer.setShader(polyShader, v.mvp, false);
                }
                float fade = a.getFade(pos.scale);
                float blendFill = a.getBlend(pos.scale);
                boolean bl = blend = s == texShader || (double)fade < 1.0;
                if ((double)fade < 1.0) {
                    GLUtils.setColor(s.uColor, a.color, fade);
                } else if (blendFill > 0.0f) {
                    if (blendFill == 1.0f) {
                        GLUtils.setColor(s.uColor, a.blendColor, 1.0f);
                    } else {
                        GLUtils.setColorBlend(s.uColor, a.color, a.blendColor, blendFill);
                    }
                } else {
                    blend |= !Color.isOpaque(a.color);
                    GLUtils.setColor(s.uColor, a.color, fade);
                }
                GLState.blend(blend);
                GLAdapter.gl.stencilFunc(514, 255, 0x80 | 1 << i);
                GLAdapter.gl.drawArrays(5, 0, 4);
                if (a.strokeWidth <= 0.0f) continue;
                GLAdapter.gl.stencilFunc(514, 128, 128);
                GLState.blend(true);
                HairLineBucket.Renderer.shader.set(v);
                GLUtils.setColor(HairLineBucket.Renderer.shader.uColor, l.area.strokeColor, 1.0f);
                GLAdapter.gl.vertexAttribPointer(HairLineBucket.Renderer.shader.aPos, 2, 5122, false, 0, l.vertexOffset << 2);
                GLAdapter.gl.uniform1f(HairLineBucket.Renderer.shader.uWidth, a.strokeWidth);
                GLAdapter.gl.drawElements(1, l.numIndices, 5123, l.indiceOffset);
                GLAdapter.gl.lineWidth(1.0f);
            }
        }

        private static Shader setShader(Shader shader, GLMatrix mvp, boolean first) {
            if (shader.useProgram() || first) {
                GLState.enableVertexArrays(shader.aPos, -1);
                GLAdapter.gl.vertexAttribPointer(shader.aPos, 2, 5122, false, 0, 0);
                mvp.setAsUniform(shader.uMVP);
            }
            return shader;
        }

        public static RenderBucket draw(RenderBucket buckets, GLViewport v, float div, boolean first) {
            GLState.test(false, true);
            Renderer.setShader(polyShader, v.mvp, first);
            int zoom = v.pos.zoomLevel;
            int cur = mCount;
            int start = mCount;
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.stencilOp(7680, 7680, 5386);
            boolean drawn = false;
            int stencilMask = 0;
            float[] box = mBBox;
            RenderBucket b = buckets;
            while (b != null && b.type == 2) {
                block14: {
                    AreaStyle area;
                    PolygonBucket pb;
                    block15: {
                        int i;
                        pb = (PolygonBucket)b;
                        area = pb.area.current();
                        if (area.fadeScale > 0 && area.fadeScale > zoom) break block14;
                        if (!((double)div > 0.5)) break block15;
                        v.mvp.prj2D(pb.bbox, 0, box, 0, 4);
                        int out = 0;
                        for (i = 0; i < 8; i += 2) {
                            int o = mScreenClip.outcode(box[i], box[i + 1]);
                            if (o == 0) {
                                out = 0;
                                break;
                            }
                            out |= o;
                        }
                        if (out == 0 || out == 15) break block15;
                        mScreenClip.clipStart(box[6], box[7]);
                        out = 0;
                        for (i = 0; i < 8 && out == 0; i += 2) {
                            out = mScreenClip.clipNext(box[i], box[i + 1]);
                        }
                        if (out == 0) break block14;
                    }
                    if (mClear) {
                        Renderer.clearStencilRegion();
                        GLAdapter.gl.stencilOp(7680, 7680, 5386);
                        cur = 0;
                        start = 0;
                    }
                    Renderer.mAreaLayer[cur] = pb;
                    int stencil = 1 << cur++;
                    if (area.hasAlpha(zoom)) {
                        GLAdapter.gl.stencilMask(stencil);
                        stencilMask = (byte)(stencilMask | stencil);
                    } else {
                        stencilMask = (byte)(stencilMask | stencil);
                        GLAdapter.gl.stencilMask(stencilMask);
                    }
                    GLAdapter.gl.drawArrays(6, b.vertexOffset, b.numVertices);
                    if (cur == 7) {
                        Renderer.fillPolygons(v, start, cur, v.pos, div);
                        drawn = true;
                        mClear = true;
                        cur = 0;
                        start = 0;
                        if (b.next != null && ((RenderBucket)b.next).type == 2) {
                            Renderer.setShader(polyShader, v.mvp, false);
                            stencilMask = 0;
                        }
                    }
                }
                b = (RenderBucket)b.next;
            }
            if (cur > 0) {
                Renderer.fillPolygons(v, start, cur, v.pos, div);
                drawn = true;
            }
            if (!drawn) {
                GLAdapter.gl.colorMask(true, true, true, true);
                GLAdapter.gl.stencilMask(0);
            }
            mCount = cur;
            return b;
        }

        public static void clip(GLMatrix mvp, int clipMode) {
            Renderer.setShader(polyShader, mvp, true);
            Renderer.drawStencilRegion(clipMode);
            GLAdapter.gl.stencilMask(0);
            GLAdapter.gl.colorMask(true, true, true, true);
        }

        static void drawStencilRegion(int clipMode) {
            mCount = 0;
            mClear = false;
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.stencilMask(255);
            if (clipMode == 2) {
                GLState.test(true, true);
                GLAdapter.gl.depthMask(true);
            } else {
                GLState.test(false, true);
            }
            GLAdapter.gl.stencilFunc(519, 128, 0);
            GLAdapter.gl.stencilOp(7680, 7680, 7681);
            GLAdapter.gl.drawArrays(5, 0, 4);
            if (clipMode == 2) {
                GLAdapter.gl.depthMask(false);
                GLState.test(false, true);
            }
            GLAdapter.gl.stencilFunc(514, 128, 128);
        }

        static void clearStencilRegion() {
            mCount = 0;
            mClear = false;
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.stencilMask(255);
            GLAdapter.gl.stencilFunc(514, 128, 128);
            GLAdapter.gl.stencilOp(7680, 7680, 7681);
            GLAdapter.gl.drawArrays(5, 0, 4);
        }

        public static void drawOver(GLMatrix mvp, int color, float alpha) {
            Renderer.setShader(polyShader, mvp, true);
            if (color == 0) {
                GLAdapter.gl.colorMask(false, false, false, false);
            } else {
                GLUtils.setColor(Renderer.polyShader.uColor, color, alpha);
                GLState.blend(true);
            }
            GLAdapter.gl.stencilFunc(514, 128, 128);
            GLAdapter.gl.stencilMask(255);
            GLState.test(false, true);
            GLAdapter.gl.stencilOp(7680, 7680, 0);
            GLAdapter.gl.drawArrays(5, 0, 4);
            if (color == 0) {
                GLAdapter.gl.colorMask(true, true, true, true);
            }
        }

        private Renderer() {
        }

        static {
            mBBox = new float[8];
            mScreenClip = new LineClipper(-1.0f, -1.0f, 1.0f, 1.0f);
        }
    }

    static class Shader
    extends GLShader {
        int uMVP;
        int uColor;
        int uScale;
        int aPos;

        Shader(String shaderFile) {
            if (!this.create(shaderFile)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.aPos = this.getAttrib("a_pos");
            this.uColor = this.getUniform("u_color");
            if ("polygon_layer_tex".equals(shaderFile)) {
                this.uScale = this.getUniform("u_scale");
            }
        }
    }
}

