/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.PointF;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymbolBucket
extends TextureBucket {
    static final Logger log = LoggerFactory.getLogger(SymbolBucket.class);
    private static final int VERTICES_PER_SPRITE = 4;
    private static final int LBIT_MASK = -2;
    private TextureItem prevTextures;
    private Inlist.List<SymbolItem> mSymbols = new Inlist.List();
    private final float[] points = new float[8];
    private final GLMatrix rotationMatrix = new GLMatrix();
    private final GLMatrix translateMatrix = new GLMatrix();

    public SymbolBucket() {
        super(6);
        this.fixed = true;
    }

    public void addSymbol(SymbolItem item) {
        this.numVertices += 4;
        for (SymbolItem it : this.mSymbols) {
            if (it.bitmap != item.bitmap) continue;
            item.next = it.next;
            it.next = item;
            return;
        }
        this.mSymbols.push(item);
    }

    public void pushSymbol(SymbolItem item) {
        this.numVertices += 4;
        this.mSymbols.push(item);
    }

    @Override
    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        this.vertexOffset = vboData.position() * 2;
        int numIndices = 0;
        this.prevTextures = this.textures;
        this.textures = null;
        TextureItem t = null;
        TextureItem lastTexture = null;
        SymbolItem it = this.mSymbols.head();
        while (it != null) {
            int width = 0;
            int height = 0;
            int x = 0;
            int y = 0;
            if (it.texRegion != null) {
                if (it.texRegion.texture.id == -1) {
                    it.texRegion.texture.upload();
                }
                if (this.textures == null || lastTexture == null || lastTexture.id != it.texRegion.texture.id) {
                    int nextOffset = 0;
                    if (t != null) {
                        nextOffset = t.offset + t.indices;
                    }
                    t = TextureItem.clone(it.texRegion.texture);
                    t.offset = nextOffset;
                    this.textures = Inlist.appendItem(this.textures, t);
                    lastTexture = t;
                }
                TextureAtlas.Rect r = it.texRegion.rect;
                x = r.x;
                y = r.y;
                width = r.w;
                height = r.h;
            } else if (it.bitmap != null) {
                t = this.getTexture(it.bitmap);
                if (t == null) {
                    t = new TextureItem(it.bitmap);
                    this.textures = Inlist.appendItem(this.textures, t);
                    t.offset = numIndices;
                    t.indices = 0;
                }
                width = t.width;
                height = t.height;
            } else {
                log.debug("Bad SymbolItem");
                continue;
            }
            short u1 = (short)(MapRenderer.COORD_SCALE * (float)x);
            short v1 = (short)(MapRenderer.COORD_SCALE * (float)y);
            short u2 = (short)(MapRenderer.COORD_SCALE * (float)(x + width));
            short v2 = (short)(MapRenderer.COORD_SCALE * (float)(y + height));
            PointF prevOffset = null;
            short x1 = 0;
            short y1 = 0;
            short x2 = 0;
            short y2 = 0;
            SymbolItem prev = it;
            while (it != null) {
                if (it.rotation == 0.0f) {
                    if (prev.bitmap != null && prev.bitmap != it.bitmap || prev.texRegion != null && prev.texRegion != it.texRegion) break;
                    if (it == prev || it.offset != prevOffset) {
                        prevOffset = it.offset;
                        if (it.offset == null) {
                            float hw = (float)width / 2.0f;
                            float hh = (float)height / 2.0f;
                            x1 = (short)(MapRenderer.COORD_SCALE * -hw);
                            x2 = (short)(MapRenderer.COORD_SCALE * hw);
                            y1 = (short)(MapRenderer.COORD_SCALE * hh);
                            y2 = (short)(MapRenderer.COORD_SCALE * -hh);
                        } else {
                            float hw = it.offset.x * (float)width;
                            float hh = it.offset.y * (float)height;
                            x1 = (short)(MapRenderer.COORD_SCALE * -hw);
                            x2 = (short)(MapRenderer.COORD_SCALE * ((float)width - hw));
                            y1 = (short)(MapRenderer.COORD_SCALE * ((float)height - hh));
                            y2 = (short)(MapRenderer.COORD_SCALE * -hh);
                        }
                    }
                    short tx = (short)((int)(MapRenderer.COORD_SCALE * it.x) & 0xFFFFFFFE | (it.billboard ? 1 : 0));
                    short ty = (short)(MapRenderer.COORD_SCALE * it.y);
                    this.vertexItems.add(tx, ty, x1, y1, u1, v2);
                    this.vertexItems.add(tx, ty, x1, y2, u1, v1);
                    this.vertexItems.add(tx, ty, x2, y1, u2, v2);
                    this.vertexItems.add(tx, ty, x2, y2, u2, v1);
                } else {
                    short offsetY;
                    short offsetX;
                    if (prev.bitmap != null && prev.bitmap != it.bitmap && prev.rotation != it.rotation || prev.texRegion != null && prev.texRegion != it.texRegion && prev.rotation != it.rotation) break;
                    if (it.offset == null) {
                        offsetX = 0;
                        offsetY = 0;
                    } else {
                        offsetX = (short)(((float)width / 2.0f - it.offset.x * (float)width) * MapRenderer.COORD_SCALE);
                        offsetY = (short)(((float)height / 2.0f - it.offset.y * (float)height) * MapRenderer.COORD_SCALE);
                    }
                    float hw = (float)width / 2.0f;
                    float hh = (float)height / 2.0f;
                    float minX = MapRenderer.COORD_SCALE * -hw;
                    float maxX = MapRenderer.COORD_SCALE * hw;
                    float minY = MapRenderer.COORD_SCALE * hh;
                    float maxY = MapRenderer.COORD_SCALE * -hh;
                    this.points[0] = minX;
                    this.points[1] = minY;
                    this.points[2] = minX;
                    this.points[3] = maxY;
                    this.points[6] = maxX;
                    this.points[7] = maxY;
                    this.points[4] = maxX;
                    this.points[5] = minY;
                    if (it.rotation != 0.0f) {
                        this.rotationMatrix.setRotation(it.rotation, 0.0f, 0.0f, 1.0f);
                        this.rotationMatrix.prj2D(this.points, 0, 4);
                    }
                    short tx = (short)(((int)(MapRenderer.COORD_SCALE * it.x) & 0xFFFFFFFE | (it.billboard ? 1 : 0)) + offsetX);
                    short ty = (short)(MapRenderer.COORD_SCALE * it.y + (float)offsetY);
                    this.vertexItems.add((float)tx, (float)ty, this.points[0], this.points[1], (float)u1, (float)v2);
                    this.vertexItems.add((float)tx, (float)ty, this.points[2], this.points[3], (float)u1, (float)v1);
                    this.vertexItems.add((float)tx, (float)ty, this.points[4], this.points[5], (float)u2, (float)v2);
                    this.vertexItems.add((float)tx, (float)ty, this.points[6], this.points[7], (float)u2, (float)v1);
                }
                t.indices += 6;
                it = (SymbolItem)it.next;
            }
            numIndices += t.indices;
        }
        this.vertexItems.compile(vboData);
        for (t = this.prevTextures; t != null; t = t.dispose()) {
        }
        this.prevTextures = null;
    }

    private TextureItem getTexture(Bitmap bitmap) {
        TextureItem t = this.prevTextures;
        while (t != null) {
            if (t.bitmap == bitmap) {
                this.prevTextures = Inlist.remove(this.prevTextures, t);
                this.textures = Inlist.appendItem(this.textures, t);
                t.offset = 0;
                t.indices = 0;
                return t;
            }
            t = (TextureItem)t.next;
        }
        return null;
    }

    public void clearItems() {
        SymbolItem.pool.releaseAll(this.mSymbols.clear());
    }

    @Override
    public void clear() {
        super.clear();
        this.clearItems();
    }
}

